/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.init.Registration;

public final class GearTypeIngredient
extends Ingredient {
    private final GearType type;

    private GearTypeIngredient(GearType type) {
        super(Registration.ITEMS.getEntries().stream().filter(iro -> iro.isPresent() && iro.get() instanceof ICoreItem).map(iro -> (ICoreItem)iro.get()).filter(item -> item.getGearType().matches(type)).map(item -> new Ingredient.SingleItemList(new ItemStack((IItemProvider)item))));
        this.type = type;
    }

    public static GearTypeIngredient of(GearType type) {
        return new GearTypeIngredient(type);
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b() instanceof ICoreItem && ((ICoreItem)stack.func_77973_b()).getGearType().matches(this.type);
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.NAME.toString());
        json.addProperty("gear_type", this.type.getName());
        return json;
    }

    public static final class Serializer
    implements IIngredientSerializer<GearTypeIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation NAME = new ResourceLocation("silentgear", "gear_type");

        private Serializer() {
        }

        public GearTypeIngredient parse(PacketBuffer buffer) {
            String typeName = buffer.func_218666_n();
            GearType type = GearType.get(typeName);
            if (type.isInvalid()) {
                throw new JsonParseException("Unknown gear type: " + typeName);
            }
            return new GearTypeIngredient(type);
        }

        public GearTypeIngredient parse(JsonObject json) {
            String typeName = JSONUtils.func_151219_a((JsonObject)json, (String)"gear_type", (String)"");
            if (typeName.isEmpty()) {
                throw new JsonSyntaxException("'gear_type' is missing");
            }
            GearType type = GearType.get(typeName);
            if (type.isInvalid()) {
                throw new JsonSyntaxException("gear_type " + typeName + " does not exist");
            }
            return new GearTypeIngredient(type);
        }

        public void write(PacketBuffer buffer, GearTypeIngredient ingredient) {
            buffer.func_180714_a(ingredient.type.getName());
        }
    }
}

