/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.crafting.ingredient.IGearIngredient;
import net.silentchaos512.gear.item.blueprint.IBlueprint;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.utils.Color;

public class BlueprintIngredient
extends Ingredient
implements IGearIngredient {
    private final PartType partType;
    private final GearType gearType;

    private BlueprintIngredient(PartType partType, GearType gearType) {
        super(Stream.of(new Ingredient.IItemList[0]));
        this.partType = partType;
        this.gearType = gearType;
    }

    public static <T extends Item> BlueprintIngredient of(T item) {
        ItemStack stack = new ItemStack(item);
        return new BlueprintIngredient(((IBlueprint)item).getPartType(stack), ((IBlueprint)item).getGearType(stack));
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() instanceof IBlueprint) {
            IBlueprint item = (IBlueprint)stack.func_77973_b();
            return item.getGearType(stack) == this.gearType && item.getPartType(stack) == this.partType;
        }
        return false;
    }

    public ItemStack[] func_193365_a() {
        return (ItemStack[])ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof IBlueprint).map(ItemStack::new).filter((Predicate<ItemStack>)((Object)this)).toArray(ItemStack[]::new);
    }

    public boolean isSimple() {
        return false;
    }

    public boolean func_203189_d() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.NAME.toString());
        if (this.partType != PartType.MAIN) {
            json.addProperty("part_type", this.partType.getName().toString());
        }
        if (this.gearType != GearType.PART) {
            json.addProperty("gear_type", this.gearType.getName());
        }
        return json;
    }

    @Override
    public PartType getPartType() {
        return this.partType;
    }

    @Override
    public GearType getGearType() {
        return this.gearType;
    }

    @Override
    public Optional<ITextComponent> getJeiHint() {
        PartGearKey key = PartGearKey.of(this.gearType, this.partType);
        StringTextComponent keyText = new StringTextComponent(key.toString());
        IFormattableTextComponent text = TextUtil.withColor((IFormattableTextComponent)keyText, Color.DODGERBLUE);
        return Optional.of(TextUtil.translate("jei", "blueprintType", text));
    }

    public static final class Serializer
    implements IIngredientSerializer<BlueprintIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation NAME = SilentGear.getId("blueprint");

        private Serializer() {
        }

        public BlueprintIngredient parse(PacketBuffer buffer) {
            ResourceLocation typeName = buffer.func_192575_l();
            PartType partType = PartType.get(typeName);
            if (partType == null) {
                throw new JsonParseException("Unknown part type: " + typeName);
            }
            GearType gearType = GearType.get(buffer.func_218666_n());
            if (gearType.isInvalid()) {
                throw new JsonParseException("Unknown gear type: " + typeName);
            }
            return new BlueprintIngredient(partType, gearType);
        }

        public BlueprintIngredient parse(JsonObject json) {
            String typeName = JSONUtils.func_151219_a((JsonObject)json, (String)"part_type", (String)"main");
            PartType type = PartType.get(Objects.requireNonNull(SilentGear.getIdWithDefaultNamespace(typeName)));
            if (type == null) {
                throw new JsonSyntaxException("part_type " + typeName + " does not exist");
            }
            String gearTypeName = JSONUtils.func_151219_a((JsonObject)json, (String)"gear_type", (String)"part");
            GearType gearType = GearType.get(gearTypeName);
            if (gearType.isInvalid()) {
                throw new JsonSyntaxException("gear_type " + gearTypeName + " does not exist");
            }
            return new BlueprintIngredient(type, gearType);
        }

        public void write(PacketBuffer buffer, BlueprintIngredient ingredient) {
            buffer.func_192572_a(ingredient.partType.getName());
            buffer.func_180714_a(ingredient.gearType.getName());
        }
    }
}

