/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.jei;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.util.IGearComponent;
import net.silentchaos512.gear.block.grader.GraderScreen;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModTags;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.TextUtil;

public class MaterialGraderRecipeCategory
implements IRecipeCategory<GraderRecipe> {
    private static final int GUI_START_X = 24;
    private static final int GUI_START_Y = 33;
    private static final int GUI_WIDTH = 19;
    private static final int GUI_HEIGHT = 39;
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;

    public MaterialGraderRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GraderScreen.TEXTURE, 24, 33, 19, 39);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(ModBlocks.MATERIAL_GRADER));
        this.localizedName = TextUtil.translate("jei", "category.grading").getString();
    }

    public ResourceLocation getUid() {
        return Const.GRADING;
    }

    public Class<? extends GraderRecipe> getRecipeClass() {
        return GraderRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(GraderRecipe graderRecipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, (List)ImmutableList.of(MaterialGraderRecipeCategory.getMaterials(), MaterialGraderRecipeCategory.getCatalysts()));
    }

    @Nonnull
    public static List<ItemStack> getMaterials() {
        return MaterialManager.getValues().stream().map(IGearComponent::getIngredient).flatMap(ing -> Arrays.stream(ing.func_193365_a())).collect(Collectors.toList());
    }

    @Nonnull
    public static List<ItemStack> getCatalysts() {
        return ModTags.Items.GRADER_CATALYSTS.func_230236_b_().stream().map(ItemStack::new).collect(Collectors.toList());
    }

    public void setRecipe(IRecipeLayout recipeLayout, GraderRecipe graderRecipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 1, 1);
        itemStacks.init(1, true, 1, 21);
        itemStacks.set(0, MaterialGraderRecipeCategory.getMaterials());
        itemStacks.set(1, MaterialGraderRecipeCategory.getCatalysts());
    }

    public static class GraderRecipe {
    }
}

