/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.silentchaos512.gear.network.KeyPressOnItemPacket;
import net.silentchaos512.gear.network.Network;

@Mod.EventBusSubscriber(modid="silentgear", value={Dist.CLIENT})
public class KeyTracker {
    public static final KeyBinding DISPLAY_STATS = KeyTracker.createKeyBinding("displayStats", 341);
    public static final KeyBinding DISPLAY_TRAITS = KeyTracker.createKeyBinding("displayTraits", 340);
    public static final KeyBinding DISPLAY_CONSTRUCTION = KeyTracker.createKeyBinding("displayConstruction", 342);
    public static final KeyBinding OPEN_ITEM = KeyTracker.createKeyBinding("openItem", 88);
    public static final KeyBinding CYCLE_BACK = KeyTracker.createKeyBinding("cycle.back", 90);
    public static final KeyBinding CYCLE_NEXT = KeyTracker.createKeyBinding("cycle.next", 67);
    private static int materialCycleCount = 0;

    public static void register(FMLClientSetupEvent event) {
        ClientRegistry.registerKeyBinding((KeyBinding)CYCLE_BACK);
        ClientRegistry.registerKeyBinding((KeyBinding)CYCLE_NEXT);
        ClientRegistry.registerKeyBinding((KeyBinding)DISPLAY_STATS);
        ClientRegistry.registerKeyBinding((KeyBinding)DISPLAY_TRAITS);
        ClientRegistry.registerKeyBinding((KeyBinding)DISPLAY_CONSTRUCTION);
        ClientRegistry.registerKeyBinding((KeyBinding)OPEN_ITEM);
    }

    @Nonnull
    private static KeyBinding createKeyBinding(String description, int key) {
        return new KeyBinding("key.silentgear." + description, (IKeyConflictContext)KeyConflictContext.GUI, InputMappings.Type.KEYSYM, key, "key.categories.silentgear");
    }

    public static int getMaterialCycleIndex(int total) {
        int i = materialCycleCount % total;
        return i < 0 ? i + total : i;
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        ItemStack hovered;
        if (event.getAction() == 0 && event.getKey() == DISPLAY_STATS.getKey().func_197937_c()) {
            materialCycleCount = 0;
        }
        if (event.getAction() == 1 && event.getKey() == CYCLE_NEXT.getKey().func_197937_c()) {
            if (KeyTracker.isDisplayStatsDown()) {
                ++materialCycleCount;
            }
            if (!(hovered = KeyTracker.getHoveredItem()).func_190926_b()) {
                Network.channel.sendToServer((Object)new KeyPressOnItemPacket(KeyPressOnItemPacket.Type.CYCLE_NEXT, KeyTracker.getHoveredSlot()));
            }
        }
        if (event.getAction() == 1 && event.getKey() == CYCLE_BACK.getKey().func_197937_c()) {
            if (KeyTracker.isDisplayStatsDown()) {
                --materialCycleCount;
            }
            if (!(hovered = KeyTracker.getHoveredItem()).func_190926_b()) {
                Network.channel.sendToServer((Object)new KeyPressOnItemPacket(KeyPressOnItemPacket.Type.CYCLE_BACK, KeyTracker.getHoveredSlot()));
            }
        }
        if (event.getAction() == 1 && event.getKey() == OPEN_ITEM.getKey().func_197937_c() && !(hovered = KeyTracker.getHoveredItem()).func_190926_b()) {
            Network.channel.sendToServer((Object)new KeyPressOnItemPacket(KeyPressOnItemPacket.Type.OPEN_ITEM, KeyTracker.getHoveredSlot()));
        }
    }

    private static ItemStack getHoveredItem() {
        ContainerScreen containerScreen;
        Slot slot;
        Screen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (currentScreen instanceof ContainerScreen && (slot = (containerScreen = (ContainerScreen)currentScreen).getSlotUnderMouse()) != null) {
            return slot.func_75211_c();
        }
        return ItemStack.field_190927_a;
    }

    private static int getHoveredSlot() {
        ContainerScreen containerScreen;
        Slot slot;
        Screen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (currentScreen instanceof ContainerScreen && (slot = (containerScreen = (ContainerScreen)currentScreen).getSlotUnderMouse()) != null) {
            return slot.field_75222_d;
        }
        return -1;
    }

    public static boolean isDisplayStatsDown() {
        int code = DISPLAY_STATS.getKey().func_197937_c();
        if (code == 341 || code == 345 || DISPLAY_STATS.func_197986_j()) {
            return KeyTracker.isControlDown();
        }
        return DISPLAY_STATS.func_151470_d();
    }

    public static boolean isDisplayConstructionDown() {
        int code = DISPLAY_CONSTRUCTION.getKey().func_197937_c();
        if (code == 342 || code == 346 || DISPLAY_CONSTRUCTION.func_197986_j()) {
            return KeyTracker.isAltDown();
        }
        return DISPLAY_CONSTRUCTION.func_151470_d();
    }

    public static boolean isDisplayTraitsDown() {
        int code = DISPLAY_TRAITS.getKey().func_197937_c();
        if (code == 340 || code == 344 || DISPLAY_TRAITS.func_197986_j()) {
            return KeyTracker.isShiftDown();
        }
        return DISPLAY_TRAITS.func_151470_d();
    }

    public static boolean isShiftDown() {
        long h = Minecraft.func_71410_x().func_228018_at_().func_198092_i();
        return InputMappings.func_216506_a((long)h, (int)340) || InputMappings.func_216506_a((long)h, (int)344);
    }

    public static boolean isControlDown() {
        long h = Minecraft.func_71410_x().func_228018_at_().func_198092_i();
        return InputMappings.func_216506_a((long)h, (int)341) || InputMappings.func_216506_a((long)h, (int)345);
    }

    public static boolean isAltDown() {
        long h = Minecraft.func_71410_x().func_228018_at_().func_198092_i();
        return InputMappings.func_216506_a((long)h, (int)342) || InputMappings.func_216506_a((long)h, (int)346);
    }
}

