/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.util;

import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.part.PartType;

public final class PartGearKey {
    private static final Map<Pair<GearType, PartType>, PartGearKey> CACHE = new HashMap<Pair<GearType, PartType>, PartGearKey>();
    private final String key;
    private final GearType gearType;
    private final PartType partType;

    private PartGearKey(GearType gearType, PartType partType) {
        this.key = SilentGear.shortenId(partType.getName()) + "/" + gearType.getName();
        this.gearType = gearType;
        this.partType = partType;
    }

    public static PartGearKey of(GearType gearType, IPartData part) {
        return PartGearKey.of(gearType, part.getType());
    }

    public static PartGearKey of(GearType gearType, PartType partType) {
        return CACHE.computeIfAbsent((Pair<GearType, PartType>)Pair.of((Object)gearType, (Object)partType), pair -> new PartGearKey((GearType)pair.getFirst(), (PartType)pair.getSecond()));
    }

    public static PartGearKey ofAll(PartType partType) {
        return PartGearKey.of(GearType.ALL, partType);
    }

    @Nullable
    public PartGearKey getParent() {
        GearType parent = this.gearType.getParent();
        if (parent != null) {
            return PartGearKey.of(parent, this.partType);
        }
        return null;
    }

    public GearType getGearType() {
        return this.gearType;
    }

    public PartType getPartType() {
        return this.partType;
    }

    public static PartGearKey read(String key) {
        String[] parts = key.split("/");
        if (parts.length != 2) {
            throw new JsonParseException("invalid key: " + key);
        }
        PartType partType = PartType.getNonNull(Objects.requireNonNull(SilentGear.getIdWithDefaultNamespace(parts[0])));
        if (partType.isInvalid()) {
            throw new JsonParseException("Unknown part type: " + parts[0]);
        }
        GearType gearType = GearType.get(parts[1]);
        if (gearType.isInvalid()) {
            throw new JsonParseException("Unknown gear type: " + parts[1]);
        }
        return new PartGearKey(gearType, partType);
    }

    public String toString() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartGearKey that = (PartGearKey)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }
}

