/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.stats;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.stats.EvenSplitItemStat;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.SplitItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.lib.util.Lazy;
import net.silentchaos512.utils.Color;

public final class ItemStats {
    static final List<ItemStat> STATS_IN_ORDER = new ArrayList<ItemStat>();
    public static final Lazy<IForgeRegistry<ItemStat>> REGISTRY = Lazy.of(() -> new RegistryBuilder().setType(ItemStat.class).setName((ResourceLocation)SilentGear.getId("stat")).create());
    public static final ItemStat DURABILITY = new ItemStat(0.0f, 0.0f, 2.1474836E9f, Color.STEELBLUE, new ItemStat.Properties().displayAsInt().affectedByGrades(true).synergyApplies());
    public static final ItemStat ARMOR_DURABILITY = new ItemStat(0.0f, 0.0f, 1.3421773E8f, Color.STEELBLUE, new ItemStat.Properties().displayAsInt().displayFormat(ItemStat.DisplayFormat.MULTIPLIER).affectedByGrades(true).synergyApplies());
    public static final ItemStat REPAIR_EFFICIENCY = new ItemStat(1.0f, 0.0f, 1000.0f, Color.STEELBLUE, new ItemStat.Properties().displayFormat(ItemStat.DisplayFormat.PERCENTAGE).affectedByGrades(false));
    public static final ItemStat REPAIR_VALUE = new ItemStat(1.0f, 0.0f, 1000.0f, Color.STEELBLUE, new ItemStat.Properties().displayFormat(ItemStat.DisplayFormat.PERCENTAGE).affectedByGrades(false));
    public static final ItemStat ENCHANTABILITY = new ItemStat(0.0f, 0.0f, 2.1474836E9f, Color.STEELBLUE, new ItemStat.Properties().displayAsInt().affectedByGrades(true).synergyApplies());
    public static final ItemStat CHARGEABILITY = new ItemStat(1.0f, 0.0f, 2.1474836E9f, Color.STEELBLUE, new ItemStat.Properties().affectedByGrades(false));
    public static final ItemStat RARITY = new ItemStat(0.0f, 0.0f, 2.1474836E9f, Color.STEELBLUE, new ItemStat.Properties().displayAsInt().affectedByGrades(false));
    public static final ItemStat HARVEST_LEVEL = new ItemStat(0.0f, 0.0f, 2.1474836E9f, Color.SEAGREEN, new ItemStat.Properties().defaultOp(StatInstance.Operation.MAX).displayAsInt().affectedByGrades(false));
    public static final ItemStat HARVEST_SPEED = new ItemStat(0.0f, 0.0f, 2.1474836E9f, Color.SEAGREEN, new ItemStat.Properties().affectedByGrades(true).synergyApplies());
    public static final ItemStat REACH_DISTANCE = new ItemStat(0.0f, -100.0f, 100.0f, Color.SEAGREEN, new ItemStat.Properties().affectedByGrades(false));
    public static final ItemStat MELEE_DAMAGE = new ItemStat(0.0f, 0.0f, 2.1474836E9f, Color.SANDYBROWN, new ItemStat.Properties().affectedByGrades(true).synergyApplies());
    public static final ItemStat MAGIC_DAMAGE = new ItemStat(0.0f, 0.0f, 2.1474836E9f, Color.SANDYBROWN, new ItemStat.Properties().affectedByGrades(true).synergyApplies().hidden());
    public static final ItemStat ATTACK_SPEED = new ItemStat(0.0f, -3.9f, 4.0f, Color.SANDYBROWN, new ItemStat.Properties().affectedByGrades(false));
    public static final ItemStat ATTACK_REACH = new ItemStat(3.0f, 0.0f, 100.0f, Color.SANDYBROWN, new ItemStat.Properties().baseValue(3.0f).affectedByGrades(false));
    public static final ItemStat RANGED_DAMAGE = new ItemStat(0.0f, 0.0f, 2.1474836E9f, Color.SKYBLUE, new ItemStat.Properties().displayFormat(ItemStat.DisplayFormat.MULTIPLIER).affectedByGrades(true).synergyApplies());
    public static final ItemStat RANGED_SPEED = new ItemStat(0.0f, -10.0f, 10.0f, Color.SKYBLUE, new ItemStat.Properties().displayFormat(ItemStat.DisplayFormat.MULTIPLIER).affectedByGrades(false));
    public static final ItemStat PROJECTILE_SPEED = new ItemStat(1.0f, 0.0f, 2.1474836E9f, Color.SKYBLUE, new ItemStat.Properties().displayFormat(ItemStat.DisplayFormat.MULTIPLIER).affectedByGrades(false).synergyApplies());
    public static final ItemStat PROJECTILE_ACCURACY = new ItemStat(1.0f, 0.0f, 10000.0f, Color.SKYBLUE, new ItemStat.Properties().displayFormat(ItemStat.DisplayFormat.PERCENTAGE).affectedByGrades(false));
    public static final ItemStat ARMOR = new SplitItemStat(0.0f, 0.0f, 2.1474836E9f, Color.VIOLET, (Map<GearType, Float>)ImmutableMap.of((Object)GearType.HELMET, (Object)Float.valueOf(3.0f), (Object)GearType.CHESTPLATE, (Object)Float.valueOf(8.0f), (Object)GearType.LEGGINGS, (Object)Float.valueOf(6.0f), (Object)GearType.BOOTS, (Object)Float.valueOf(3.0f)), new ItemStat.Properties().affectedByGrades(true).synergyApplies());
    public static final ItemStat ARMOR_TOUGHNESS = new EvenSplitItemStat(0.0f, 0.0f, 2.1474836E9f, Color.VIOLET, 4, new ItemStat.Properties().affectedByGrades(true).synergyApplies());
    public static final ItemStat KNOCKBACK_RESISTANCE = new ItemStat(0.0f, 0.0f, 2.1474836E9f, Color.VIOLET, new ItemStat.Properties().affectedByGrades(true).synergyApplies());
    public static final ItemStat MAGIC_ARMOR = new EvenSplitItemStat(0.0f, 0.0f, 2.1474836E9f, Color.VIOLET, 4, new ItemStat.Properties().affectedByGrades(true).synergyApplies());

    private ItemStats() {
    }

    public static Collection<ItemStat> allStatsOrdered() {
        return Collections.unmodifiableList(STATS_IN_ORDER);
    }

    public static Collection<ItemStat> allStatsOrderedExcluding(Collection<ItemStat> exclude) {
        ArrayList<ItemStat> ret = new ArrayList<ItemStat>(STATS_IN_ORDER);
        ret.removeIf(exclude::contains);
        return ret;
    }

    @Nullable
    public static ItemStat byName(String name) {
        ResourceLocation id = SilentGear.getIdWithDefaultNamespace(name);
        return id != null ? (ItemStat)((IForgeRegistry)REGISTRY.get()).getValue(id) : null;
    }

    @Nullable
    public static ItemStat get(IItemStat stat) {
        return (ItemStat)((IForgeRegistry)REGISTRY.get()).getValue(stat.getStatId());
    }

    public static void createRegistry(RegistryEvent.NewRegistry event) {
        REGISTRY.get();
    }

    public static void registerStats(RegistryEvent.Register<ItemStat> event) {
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), DURABILITY, "durability");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), ARMOR_DURABILITY, "armor_durability");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), REPAIR_EFFICIENCY, "repair_efficiency");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), REPAIR_VALUE, "repair_value");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), ENCHANTABILITY, "enchantability");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), CHARGEABILITY, "chargeability");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), RARITY, "rarity");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), HARVEST_LEVEL, "harvest_level");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), HARVEST_SPEED, "harvest_speed");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), REACH_DISTANCE, "reach_distance");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), MELEE_DAMAGE, "melee_damage");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), MAGIC_DAMAGE, "magic_damage");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), ATTACK_SPEED, "attack_speed");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), ATTACK_REACH, "attack_reach");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), RANGED_DAMAGE, "ranged_damage");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), RANGED_SPEED, "ranged_speed");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), PROJECTILE_ACCURACY, "projectile_accuracy");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), PROJECTILE_SPEED, "projectile_speed");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), ARMOR, "armor");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), ARMOR_TOUGHNESS, "armor_toughness");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), KNOCKBACK_RESISTANCE, "knockback_resistance");
        ItemStats.register((IForgeRegistry<ItemStat>)event.getRegistry(), MAGIC_ARMOR, "magic_armor");
    }

    private static void register(IForgeRegistry<ItemStat> registry, ItemStat stat, String name) {
        registry.register(stat.setRegistryName(SilentGear.getId(name)));
    }
}

