/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.shrink.items;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gigabit101.shrink.api.ShrinkAPI;
import net.gigabit101.shrink.cap.EnergyStorageItemImpl;
import net.gigabit101.shrink.config.ShrinkConfig;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ItemShrinkRay
extends Item {
    public ItemShrinkRay(Item.Properties properties) {
        super(properties.func_208103_a(Rarity.EPIC).func_200917_a(1));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity playerEntity, Hand hand) {
        playerEntity.func_184598_c(hand);
        return super.func_77659_a(world, playerEntity, hand);
    }

    public ActionResultType func_111207_a(ItemStack itemStack, PlayerEntity playerEntity, LivingEntity livingEntity, Hand hand) {
        if (livingEntity != null && !playerEntity.field_70170_p.func_201670_d()) {
            AtomicReference<Float> scale = new AtomicReference<Float>(Float.valueOf(0.1f));
            playerEntity.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> scale.set(Float.valueOf(iShrinkProvider.scale())));
            livingEntity.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> {
                if (this.canUse(itemStack, playerEntity)) {
                    iShrinkProvider.setScale(((Float)scale.get()).floatValue());
                    if (iShrinkProvider.isShrunk()) {
                        iShrinkProvider.deShrink(livingEntity);
                    } else {
                        iShrinkProvider.shrink(livingEntity);
                    }
                }
            });
        }
        return super.func_111207_a(itemStack, playerEntity, livingEntity, hand);
    }

    public boolean canUse(ItemStack stack, PlayerEntity playerEntity) {
        IEnergyStorage energyStorage;
        if (!((Boolean)ShrinkConfig.POWER_REQUIREMENT.get()).booleanValue()) {
            return true;
        }
        if (playerEntity.func_184812_l_()) {
            return true;
        }
        LazyOptional optional = stack.getCapability(CapabilityEnergy.ENERGY);
        if (optional.isPresent() && (energyStorage = (IEnergyStorage)optional.orElseThrow(IllegalStateException::new)).getEnergyStored() >= (Integer)ShrinkConfig.POWER_COST.get()) {
            energyStorage.extractEnergy(((Integer)ShrinkConfig.POWER_COST.get()).intValue(), false);
            return true;
        }
        return false;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == CapabilityEnergy.ENERGY) {
                    return LazyOptional.of(() -> new EnergyStorageItemImpl(stack, (Integer)ShrinkConfig.POWER_CAPACITY.get(), (Integer)ShrinkConfig.POWER_CAPACITY.get(), (Integer)ShrinkConfig.POWER_CAPACITY.get())).cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return (Boolean)ShrinkConfig.POWER_REQUIREMENT.get();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0f - ItemShrinkRay.getChargeRatio(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)((1.0f + ItemShrinkRay.getChargeRatio(stack)) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        LazyOptional optional = stack.getCapability(CapabilityEnergy.ENERGY);
        if (optional.isPresent()) {
            IEnergyStorage energyStorage = (IEnergyStorage)optional.orElseThrow(IllegalStateException::new);
            tooltip.add((ITextComponent)new StringTextComponent(energyStorage.getEnergyStored() + " FE / " + energyStorage.getMaxEnergyStored() + " FE"));
        }
    }

    public static float getChargeRatio(ItemStack stack) {
        LazyOptional optional = stack.getCapability(CapabilityEnergy.ENERGY);
        if (optional.isPresent()) {
            IEnergyStorage energyStorage = (IEnergyStorage)optional.orElseThrow(IllegalStateException::new);
            return (float)energyStorage.getEnergyStored() / (float)energyStorage.getMaxEnergyStored();
        }
        return 0.0f;
    }
}

