/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.modintegration.ftbteams;

import com.feed_the_beast.mods.ftbteams.ProfileUtils;
import com.feed_the_beast.mods.ftbteams.api.FTBTeamsAPI;
import com.feed_the_beast.mods.ftbteams.api.Team;
import com.feed_the_beast.mods.ftbteams.api.TeamManager;
import com.feed_the_beast.mods.ftbteams.event.PlayerJoinedTeamEvent;
import com.feed_the_beast.mods.ftbteams.event.PlayerLeftTeamEvent;
import com.mojang.authlib.GameProfile;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import shetiphian.core.internal.modintegration.ftbteams.FTBTeams_Base;
import shetiphian.core.internal.network.NetworkHandler;
import shetiphian.core.internal.network.PacketFTBMyTeam;

public class FTBTeams_Active
extends FTBTeams_Base {
    public static void init() {
        if (TeamManager.class != null) {
            INSTANCE = new FTBTeams_Active();
            MinecraftForge.EVENT_BUS.register((Object)new FTBEventHandler());
        }
    }

    @Override
    public boolean isReady() {
        return FTBTeams_Active.getManager() != null;
    }

    private static TeamManager getManager() {
        try {
            return FTBTeamsAPI.INSTANCE.getManager();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getPlayerTeamID(PlayerEntity player) {
        if (player != null) {
            if (player.field_70170_p.field_72995_K) {
                return this.myTeam;
            }
            if (player instanceof ServerPlayerEntity) {
                TeamManager manager = FTBTeams_Active.getManager();
                if (manager != null) {
                    Optional team = manager.getTeam((ServerPlayerEntity)player);
                    return team.map(Team::getStringID).orElse("");
                }
                return "";
            }
        }
        return "";
    }

    @Override
    public String getTeamName(String teamID) {
        TeamManager manager = FTBTeams_Active.getManager();
        if (manager != null) {
            String[] parts = teamID.split("#");
            int id = 0;
            try {
                id = Integer.decode(parts[parts.length - 1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (id > 0) {
                Optional team = manager.getTeam(id);
                return team.map(value -> value.getName().getString()).orElse("");
            }
        }
        return teamID;
    }

    private static class FTBEventHandler {
        private FTBEventHandler() {
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void playerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
            if (event.getEntity() instanceof ServerPlayerEntity) {
                ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
                TeamManager manager = FTBTeams_Active.getManager();
                if (manager != null) {
                    Optional team = manager.getTeam(player);
                    NetworkHandler.sendToPlayer(new PacketFTBMyTeam(team.map(Team::getStringID).orElse("")), player);
                }
            }
        }

        @SubscribeEvent
        public void playerJoinedTeamEvent(PlayerJoinedTeamEvent event) {
            ServerPlayerEntity player = event.getPlayer();
            Team team = event.getTeam();
            NetworkHandler.sendToPlayer(new PacketFTBMyTeam(team != null ? team.getStringID() : ""), player);
        }

        @SubscribeEvent
        public void playerLeftTeamEvent(PlayerLeftTeamEvent event) {
            TeamManager manager = FTBTeams_Active.getManager();
            if (manager != null) {
                ServerPlayerEntity player = ProfileUtils.getPlayerByProfile((MinecraftServer)manager.getServer(), (GameProfile)event.getProfile());
                NetworkHandler.sendToPlayer(new PacketFTBMyTeam(""), player);
            }
        }
    }
}

