/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal;

import java.util.ArrayList;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.core.internal.Values;

public class RecipeRGB16
extends SpecialRecipe {
    public RecipeRGB16(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingInventory inv, World world) {
        int dyeCount = 0;
        ItemStack rgb16 = ItemStack.field_190927_a;
        for (int index = 0; index < inv.func_70302_i_(); ++index) {
            ItemStack invStack = inv.func_70301_a(index);
            if (this.isValid(invStack)) {
                if (invStack.func_77973_b() instanceof IRGB16_Item) {
                    if (rgb16.func_190926_b()) {
                        rgb16 = invStack.func_77946_l();
                        continue;
                    }
                    return false;
                }
                ++dyeCount;
                continue;
            }
            if (invStack.func_190926_b()) continue;
            return false;
        }
        if (!rgb16.func_190926_b() && dyeCount > 0) {
            return RGB16StackHelper.getRGB16Index(this.getCraftingResult(inv)) != RGB16StackHelper.getRGB16Index(rgb16);
        }
        return false;
    }

    private boolean isValid(ItemStack stack) {
        return !stack.func_190926_b() && (stack.func_77973_b() instanceof IRGB16_Item && ((IRGB16_Item)stack.func_77973_b()).enableDyeRecipe(stack) || DyeHelper.isDye(stack));
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack stack = ItemStack.field_190927_a;
        ArrayList<ItemStack> dye = new ArrayList<ItemStack>();
        for (int index = 0; index < inv.func_70302_i_(); ++index) {
            ItemStack invStack = inv.func_70301_a(index);
            if (invStack.func_190926_b() || !this.isValid(invStack)) continue;
            if (invStack.func_77973_b() instanceof IRGB16_Item) {
                stack = invStack.func_77946_l();
                stack.func_190920_e(1);
                continue;
            }
            dye.add(invStack);
        }
        if (!stack.func_190926_b()) {
            IRGB16_Item item = (IRGB16_Item)stack.func_77973_b();
            RGB16 rgb16 = RGB16StackHelper.getRGB16(stack);
            short startingIndex = item.getStartingIndex(stack);
            if (rgb16 == null) {
                rgb16 = new RGB16(startingIndex);
            }
            boolean first = true;
            for (ItemStack dyeStack : dye) {
                if (first && rgb16.getIndex() == startingIndex) {
                    rgb16.setValues(DyeHelper.getDyeName(dyeStack));
                } else {
                    rgb16.add(DyeHelper.getDyeName(dyeStack));
                }
                first = false;
            }
            RGB16StackHelper.setRGB16(stack, rgb16);
        }
        return stack;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Values.RecipeSerializer.rgb16_colorize;
    }
}

