/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.network;

import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import shetiphian.core.ShetiPhianCore;
import shetiphian.core.common.IConfigWrapper;
import shetiphian.core.common.PlayerConfigs;
import shetiphian.core.common.network.PacketBase;

public class PacketPlayerConfig
extends PacketBase {
    private final ResourceLocation identifier;
    private final Object object;
    private final byte type;

    private PacketPlayerConfig(ResourceLocation identifier, Object value, int type) {
        this.identifier = identifier;
        this.object = value;
        this.type = (byte)type;
    }

    public static PacketPlayerConfig syncCustom(ResourceLocation identifier, Object value) {
        return new PacketPlayerConfig(identifier, value, 0);
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, boolean value) {
        return new PacketPlayerConfig(identifier, value, 1);
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, byte value) {
        return new PacketPlayerConfig(identifier, value, 2);
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, short value) {
        return new PacketPlayerConfig(identifier, value, 3);
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, int value) {
        return new PacketPlayerConfig(identifier, value, 4);
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, long value) {
        return new PacketPlayerConfig(identifier, value, 5);
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, double value) {
        return new PacketPlayerConfig(identifier, value, 6);
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, float value) {
        return new PacketPlayerConfig(identifier, Float.valueOf(value), 7);
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, String value) {
        return new PacketPlayerConfig(identifier, value, 8);
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, ResourceLocation value) {
        return new PacketPlayerConfig(identifier, value, 9);
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, ItemStack value) {
        return new PacketPlayerConfig(identifier, value, 10);
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, UUID value) {
        return new PacketPlayerConfig(identifier, value, 11);
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, CompoundNBT value) {
        return new PacketPlayerConfig(identifier, value, 12);
    }

    public static void writeData(PacketPlayerConfig packet, PacketBuffer buffer) {
        buffer.func_192572_a(packet.identifier);
        buffer.writeByte((int)packet.type);
        switch (packet.type) {
            case 0: {
                IConfigWrapper wrapper = PlayerConfigs.getConfigWrapper(packet.identifier);
                if (wrapper != null) {
                    wrapper.toBytes(packet.identifier, packet.object, buffer);
                    break;
                }
                ShetiPhianCore.LOGGER.error("Error syncing config; Client missing IConfigWrapper registration for: " + packet.identifier);
                break;
            }
            case 1: {
                buffer.writeBoolean(((Boolean)packet.object).booleanValue());
                break;
            }
            case 2: {
                buffer.writeByte((int)((Byte)packet.object).byteValue());
                break;
            }
            case 3: {
                buffer.writeShort((int)((Short)packet.object).shortValue());
                break;
            }
            case 4: {
                buffer.func_150787_b(((Integer)packet.object).intValue());
                break;
            }
            case 5: {
                buffer.func_179254_b(((Long)packet.object).longValue());
                break;
            }
            case 6: {
                buffer.writeDouble(((Double)packet.object).doubleValue());
                break;
            }
            case 7: {
                buffer.writeFloat(((Float)packet.object).floatValue());
                break;
            }
            case 8: {
                PacketPlayerConfig.writeString(buffer, (String)packet.object);
                break;
            }
            case 9: {
                buffer.func_192572_a((ResourceLocation)packet.object);
                break;
            }
            case 10: {
                buffer.func_150788_a((ItemStack)packet.object);
                break;
            }
            case 11: {
                buffer.func_179252_a((UUID)packet.object);
                break;
            }
            case 12: {
                buffer.func_150786_a((CompoundNBT)packet.object);
            }
        }
    }

    public static PacketPlayerConfig readData(PacketBuffer buffer) {
        ResourceLocation identifier = buffer.func_192575_l();
        byte type = buffer.readByte();
        Object object = null;
        switch (type) {
            case 0: {
                IConfigWrapper wrapper = PlayerConfigs.getConfigWrapper(identifier);
                if (wrapper != null) {
                    object = wrapper.fromBytes(identifier, buffer);
                    break;
                }
                ShetiPhianCore.LOGGER.error("Error syncing config; Server missing IConfigWrapper registration for: " + identifier);
                break;
            }
            case 1: {
                object = buffer.readBoolean();
                break;
            }
            case 2: {
                object = buffer.readByte();
                break;
            }
            case 3: {
                object = buffer.readShort();
                break;
            }
            case 4: {
                object = buffer.func_150792_a();
                break;
            }
            case 5: {
                object = buffer.func_179260_f();
                break;
            }
            case 6: {
                object = buffer.readDouble();
                break;
            }
            case 7: {
                object = Float.valueOf(buffer.readFloat());
                break;
            }
            case 8: {
                object = PacketPlayerConfig.readString(buffer);
                break;
            }
            case 9: {
                object = buffer.func_192575_l();
                break;
            }
            case 10: {
                object = buffer.func_150791_c();
                break;
            }
            case 11: {
                object = buffer.func_179253_g();
                break;
            }
            case 12: {
                object = buffer.func_150793_b();
            }
        }
        return new PacketPlayerConfig(identifier, object, type);
    }

    @Override
    public void handleClientSide(PlayerEntity player) {
    }

    @Override
    public void handleServerSide(PlayerEntity player) {
        PlayerConfigs.setConfigs(player, this.identifier, this.object);
    }
}

