/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.item;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import shetiphian.core.common.MyDamageSource;

public abstract class ItemToolWithDamageSource
extends ToolItem {
    private MyDamageSource damageSource;

    public ItemToolWithDamageSource(float damage, float speed, IItemTier tier, MyDamageSource damageSource, Item.Properties properties) {
        this(damage, speed, tier, damageSource, Sets.newHashSet((Object[])new Block[0]), properties);
    }

    public ItemToolWithDamageSource(float damage, float speed, IItemTier tier, MyDamageSource damageSource, Set<Block> blocks, Item.Properties properties) {
        super(damage, speed, tier, blocks, properties);
        this.damageSource = damageSource;
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity victim) {
        if (victim.func_70075_an() && !victim.func_85031_j((Entity)player)) {
            AttackValues values = ItemToolWithDamageSource.calculateBaseValues(player, victim, null);
            values.bonusDamage = this.getBonusDamage(player, victim, this.damageSource, values.damage, values.bonusDamage);
            values.knockback = this.getKnockback(player, victim, this.damageSource, values.knockback);
            if ((values.damage > 0.0f || values.bonusDamage > 0.0f) && ItemToolWithDamageSource.preformDamage(player, victim, this.damageSource, null, values)) {
                this.postHurtEntity(player, victim, this.damageSource);
            }
        }
        return true;
    }

    public static boolean onLeftClickEntity(PlayerEntity player, Entity victim, MyDamageSource damageSource, ItemStack extraModifiers) {
        AttackValues values;
        if (victim.func_70075_an() && !victim.func_85031_j((Entity)player) && ((values = ItemToolWithDamageSource.calculateBaseValues(player, victim, extraModifiers)).damage > 0.0f || values.bonusDamage > 0.0f) && ItemToolWithDamageSource.preformDamage(player, victim, damageSource, extraModifiers, values)) {
            player.func_71020_j(0.3f);
        }
        return true;
    }

    private static AttackValues calculateBaseValues(PlayerEntity player, Entity victim, ItemStack extraModifiers) {
        AttackValues values = new AttackValues();
        values.damage = (float)player.func_110148_a(Attributes.field_233823_f_).func_111126_e();
        if (victim instanceof LivingEntity) {
            values.bonusDamage = EnchantmentHelper.func_152377_a((ItemStack)player.func_184614_ca(), (CreatureAttribute)((LivingEntity)victim).func_70668_bt());
            values.knockback = EnchantmentHelper.func_77501_a((LivingEntity)player);
            if (extraModifiers != null) {
                AttackValues attackValues = values;
                attackValues.bonusDamage = attackValues.bonusDamage + EnchantmentHelper.func_152377_a((ItemStack)extraModifiers, (CreatureAttribute)((LivingEntity)victim).func_70668_bt());
                attackValues = values;
                attackValues.knockback = attackValues.knockback + EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)extraModifiers);
            }
        } else {
            values.bonusDamage = EnchantmentHelper.func_152377_a((ItemStack)player.func_184614_ca(), (CreatureAttribute)CreatureAttribute.field_223222_a_);
            if (extraModifiers != null) {
                AttackValues attackValues = values;
                attackValues.bonusDamage = attackValues.bonusDamage + EnchantmentHelper.func_152377_a((ItemStack)extraModifiers, (CreatureAttribute)CreatureAttribute.field_223222_a_);
            }
        }
        values.strength = player.func_184825_o(0.5f);
        values.damage = values.damage * (0.2f + values.strength * values.strength * 0.8f);
        values.bonusDamage = values.bonusDamage * values.strength;
        player.func_184821_cY();
        if (player.func_70051_ag()) {
            values.knockback++;
        }
        return values;
    }

    protected float getBonusDamage(PlayerEntity player, Entity victim, MyDamageSource source, float damage, float bonusDamage) {
        return bonusDamage;
    }

    protected int getKnockback(PlayerEntity player, Entity victim, MyDamageSource source, int knockback) {
        return knockback;
    }

    private static boolean preformDamage(PlayerEntity player, Entity victim, MyDamageSource damageSource, ItemStack extraModifiers, AttackValues values) {
        ItemStack itemstack;
        AttackValues attackValues;
        boolean isStrongAttack = values.strength > 0.9f;
        boolean flag1 = false;
        boolean flag3 = false;
        if (player.func_70051_ag() && isStrongAttack) {
            player.func_130014_f_().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187721_dT, player.func_184176_by(), 1.0f, 1.0f);
            flag1 = true;
        }
        boolean doBoostDamage = isStrongAttack && player.field_70143_R > 0.0f && !player.func_233570_aj_() && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Effects.field_76440_q) && !player.func_184218_aH() && victim instanceof LivingEntity;
        doBoostDamage = doBoostDamage && !player.func_70051_ag();
        CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((PlayerEntity)player, (Entity)victim, (boolean)doBoostDamage, (float)(doBoostDamage ? 1.5f : 1.0f));
        boolean bl = doBoostDamage = hitResult != null;
        if (doBoostDamage) {
            attackValues = values;
            attackValues.damage = attackValues.damage * hitResult.getDamageModifier();
        }
        attackValues = values;
        attackValues.damage = attackValues.damage + values.bonusDamage;
        double d0 = player.field_70140_Q - player.field_70141_P;
        if (isStrongAttack && !doBoostDamage && !flag1 && player.func_233570_aj_() && d0 < (double)player.func_70689_ay() && !(itemstack = player.func_184586_b(Hand.MAIN_HAND)).func_190926_b() && itemstack.func_77973_b() instanceof SwordItem) {
            flag3 = true;
        }
        float victimHealthPreAttack = 0.0f;
        boolean victimOnFire = false;
        int fireDamage = EnchantmentHelper.func_90036_a((LivingEntity)player);
        if (extraModifiers != null) {
            fireDamage += EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)extraModifiers);
        }
        if (victim instanceof LivingEntity) {
            victimHealthPreAttack = ((LivingEntity)victim).func_110143_aJ();
            if (fireDamage > 0 && !victim.func_70027_ad()) {
                victimOnFire = true;
                victim.func_70015_d(1);
            }
        }
        Vector3d vec3d = victim.func_213322_ci();
        boolean victimWasHurt = damageSource != null ? victim.func_70097_a(damageSource.causeEntityDamage((Entity)player), values.damage) : victim.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), values.damage);
        if (victimWasHurt) {
            if (values.knockback > 0) {
                if (victim instanceof LivingEntity) {
                    ((LivingEntity)victim).func_233627_a_((float)values.knockback * 0.5f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                } else {
                    victim.func_70024_g((double)(-MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))) * (float)values.knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180))) * (float)values.knockback * 0.5f));
                }
                player.func_213317_d(player.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
                player.func_70031_b(false);
            }
            if (flag3) {
                for (LivingEntity livingEntity : player.func_130014_f_().func_217357_a(LivingEntity.class, victim.func_174813_aQ().func_72321_a(1.0, 0.25, 1.0))) {
                    if (livingEntity == player || livingEntity == victim || player.func_184191_r((Entity)livingEntity) || !(player.func_70068_e((Entity)livingEntity) < 9.0)) continue;
                    livingEntity.func_233627_a_(0.4f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                    livingEntity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 1.0f);
                }
                player.func_130014_f_().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187730_dW, player.func_184176_by(), 1.0f, 1.0f);
                player.func_184810_cG();
            }
            if (victim instanceof ServerPlayerEntity && victim.field_70133_I) {
                ((ServerPlayerEntity)victim).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(victim));
                victim.field_70133_I = false;
                victim.func_213317_d(vec3d);
            }
            if (doBoostDamage) {
                player.func_130014_f_().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187718_dS, player.func_184176_by(), 1.0f, 1.0f);
                player.func_71009_b(victim);
            }
            if (!doBoostDamage && !flag3) {
                if (isStrongAttack) {
                    player.func_130014_f_().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187727_dV, player.func_184176_by(), 1.0f, 1.0f);
                } else {
                    player.func_130014_f_().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187733_dX, player.func_184176_by(), 1.0f, 1.0f);
                }
            }
            if (values.bonusDamage > 0.0f) {
                player.func_71047_c(victim);
            }
            if (!player.func_130014_f_().field_72995_K && victim instanceof PlayerEntity) {
                ItemStack itemStack3;
                PlayerEntity entityplayer = (PlayerEntity)victim;
                ItemStack itemStack2 = player.func_184614_ca();
                ItemStack itemStack = itemStack3 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemStack2.func_190926_b() && !itemStack3.func_190926_b() && itemStack2.func_77973_b() instanceof AxeItem && itemStack3.func_77973_b() == Items.field_185159_cQ) {
                    float f3 = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)player) * 0.05f;
                    if (flag1) {
                        f3 += 0.75f;
                    }
                    if (player.func_130014_f_().field_73012_v.nextFloat() < f3) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        player.func_130014_f_().func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            if (values.damage >= 0.0f) {
                player.func_71047_c(victim);
            }
            player.func_130011_c(victim);
            if (victim instanceof LivingEntity) {
                EnchantmentHelper.func_151384_a((LivingEntity)((LivingEntity)victim), (Entity)player);
            }
            EnchantmentHelper.func_151385_b((LivingEntity)player, (Entity)victim);
            ItemStack equippedItem = player.func_184614_ca();
            Entity entity = victim;
            if (victim instanceof EnderDragonPartEntity) {
                entity = ((EnderDragonPartEntity)victim).field_213852_b;
            }
            if (!equippedItem.func_190926_b() && entity instanceof LivingEntity) {
                equippedItem.func_77961_a((LivingEntity)entity, player);
                if (equippedItem.func_190916_E() <= 0) {
                    player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                }
            }
            if (victim instanceof LivingEntity) {
                float victimHealthPostAttack = victimHealthPreAttack - ((LivingEntity)victim).func_110143_aJ();
                player.func_195067_a(Stats.field_188111_y, Math.round(victimHealthPostAttack * 10.0f));
                if (fireDamage > 0) {
                    victim.func_70015_d(fireDamage * 4);
                }
                if (player.func_130014_f_() instanceof ServerWorld && victimHealthPostAttack > 2.0f) {
                    int k = (int)((double)victimHealthPostAttack * 0.5);
                    ((ServerWorld)player.func_130014_f_()).func_195598_a((IParticleData)ParticleTypes.field_197615_h, victim.func_226277_ct_(), victim.func_226278_cu_() + (double)(victim.func_213302_cg() * 0.5f), victim.func_226281_cx_(), k, 0.1, 0.0, 0.1, 0.2);
                }
            }
            player.func_71020_j(0.3f);
        } else {
            player.func_130014_f_().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187724_dU, player.func_184176_by(), 1.0f, 1.0f);
            if (victimOnFire) {
                victim.func_70066_B();
            }
        }
        return victimWasHurt;
    }

    protected void postHurtEntity(PlayerEntity player, Entity victim, MyDamageSource source) {
        player.func_71020_j(0.3f);
    }

    private static class AttackValues {
        private float damage;
        private int knockback;
        private float bonusDamage;
        private float strength;

        private AttackValues() {
        }
    }
}

