/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.inventory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.INameable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import shetiphian.core.common.inventory.IContainerCallback;

public class InventoryInternal
implements IInventory,
INameable {
    protected final ItemStack[] contents;
    private final String saveName;
    private final int stackLimit;
    private final TileEntity invOwner;
    private final String displayName;
    private final IContainerCallback callback;

    public InventoryInternal(TileEntity invOwner, String saveName, int invSize, String displayName) {
        this(invOwner, saveName, invSize, 64, displayName);
    }

    public InventoryInternal(TileEntity invOwner, String saveName, int invSize, String displayName, IContainerCallback callback) {
        this(invOwner, saveName, invSize, 64, displayName, invOwner instanceof IContainerCallback ? (IContainerCallback)invOwner : null);
    }

    public InventoryInternal(TileEntity invOwner, String saveName, int invSize, int invStackLimit, String displayName) {
        this(invOwner, saveName, invSize, invStackLimit, displayName, invOwner instanceof IContainerCallback ? (IContainerCallback)invOwner : null);
    }

    public InventoryInternal(TileEntity invOwner, String saveName, int invSize, int invStackLimit, String displayName, IContainerCallback callback) {
        this.contents = new ItemStack[invSize];
        this.invOwner = invOwner;
        this.saveName = saveName;
        this.stackLimit = invStackLimit;
        this.displayName = displayName;
        this.callback = callback;
        this.func_174888_l();
    }

    public void writeToNBT(CompoundNBT nbtTag) {
        this.writeToNBT(nbtTag, this.saveName);
    }

    public void writeToNBT(CompoundNBT nbtTag, String name) {
        ListNBT listStacks = new ListNBT();
        for (int index = 0; index < Math.min(this.contents.length, 256); index = (int)((short)(index + 1))) {
            if (this.contents[index].func_190926_b()) continue;
            CompoundNBT entry = new CompoundNBT();
            entry.func_74774_a("slot", (byte)index);
            this.contents[index].func_77955_b(entry);
            listStacks.add((Object)entry);
        }
        nbtTag.func_218657_a(name, (INBT)listStacks);
    }

    public void readFromNBT(CompoundNBT nbtTag) {
        this.readFromNBT(nbtTag, this.saveName);
    }

    public void readFromNBT(CompoundNBT nbtTag, String name) {
        this.func_174888_l();
        ListNBT listStacks = nbtTag.func_150295_c(name, 10);
        for (int index = 0; index < listStacks.size(); index = (int)((short)(index + 1))) {
            CompoundNBT entry = listStacks.func_150305_b(index);
            int slot = (entry.func_74764_b("slot") ? entry.func_74771_c("slot") : entry.func_74771_c("Slot")) & 0xFF;
            if (!this.okSlotId(index)) continue;
            this.contents[slot] = ItemStack.func_199557_a((CompoundNBT)entry);
        }
    }

    public ItemStack[] getContents() {
        return this.contents;
    }

    protected boolean okSlotId(int slotId) {
        return slotId > -1 && slotId < this.contents.length;
    }

    public int func_70302_i_() {
        return this.contents.length;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.contents) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack func_70301_a(int slotId) {
        return this.okSlotId(slotId) ? this.contents[slotId] : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_70298_a(int slotId, int amount) {
        if (this.okSlotId(slotId) && !this.contents[slotId].func_190926_b()) {
            if (this.contents[slotId].func_190916_E() > amount) {
                ItemStack result = this.contents[slotId].func_77979_a(amount);
                this.func_70296_d();
                return result;
            }
            ItemStack stack = this.contents[slotId];
            this.func_70299_a(slotId, ItemStack.field_190927_a);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_70304_b(int slotId) {
        ItemStack returnStack = this.func_70301_a(slotId);
        this.func_70299_a(slotId, ItemStack.field_190927_a);
        return returnStack;
    }

    public void func_70299_a(int slotId, @Nonnull ItemStack stack) {
        if (this.okSlotId(slotId)) {
            this.contents[slotId] = !stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_() ? stack.func_77979_a(this.func_70297_j_()) : stack;
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return this.stackLimit;
    }

    public void func_70296_d() {
        if (this.invOwner != null) {
            this.invOwner.func_70296_d();
        }
        if (this.callback != null) {
            this.callback.onInventoryChange(this.invOwner, this);
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        boolean original;
        boolean bl = original = this.invOwner != null && this.invOwner.func_145831_w().func_175625_s(this.invOwner.func_174877_v()) == this.invOwner && player.func_70092_e((double)this.invOwner.func_174877_v().func_177958_n() + 0.5, (double)this.invOwner.func_174877_v().func_177956_o() + 0.5, (double)this.invOwner.func_174877_v().func_177952_p() + 0.5) <= 64.0;
        if (this.callback != null) {
            return this.callback.canInteractWith(this.invOwner, this, player, original);
        }
        return original;
    }

    public void func_174889_b(PlayerEntity player) {
        if (this.callback != null) {
            this.callback.onContainerOpen(this.invOwner, this, player);
        }
    }

    public void func_174886_c(PlayerEntity player) {
        if (this.callback != null) {
            this.callback.onContainerClosed(this.invOwner, this, player);
        }
    }

    public boolean func_94041_b(int slotId, @Nonnull ItemStack stack) {
        return this.okSlotId(slotId);
    }

    public void func_174888_l() {
        for (int slot = 0; slot < this.contents.length; ++slot) {
            this.contents[slot] = ItemStack.field_190927_a;
        }
    }

    public ITextComponent func_200200_C_() {
        return new TranslationTextComponent(this.displayName);
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return null;
    }
}

