/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import com.google.common.base.Strings;
import com.mojang.datafixers.types.Type;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryHelper {
    public static Block register(IForgeRegistry<Block> registry, Block block, String id) {
        if (registry != null && block != null && !Strings.isNullOrEmpty((String)id)) {
            registry.register(block.setRegistryName(id));
            return block;
        }
        return null;
    }

    public static BlockItem register(IForgeRegistry<Item> registry, BlockItem item) {
        return RegistryHelper.register(registry, item, null);
    }

    public static BlockItem register(IForgeRegistry<Item> registry, BlockItem item, String id) {
        if (registry != null && item != null) {
            Block block;
            if (Strings.isNullOrEmpty((String)id) && (block = item.func_179223_d()) != null && block.getRegistryName() != null) {
                id = block.getRegistryName().toString();
            }
            if (!Strings.isNullOrEmpty((String)id)) {
                registry.register(item.setRegistryName(id));
                return item;
            }
        }
        return null;
    }

    public static Item register(IForgeRegistry<Item> registry, Item item, String id) {
        if (registry != null && item != null && !Strings.isNullOrEmpty((String)id)) {
            registry.register(item.setRegistryName(id));
            return item;
        }
        return null;
    }

    public static Potion register(IForgeRegistry<Potion> registry, Potion potion, String id) {
        if (registry != null && potion != null && !Strings.isNullOrEmpty((String)id)) {
            registry.register(potion.setRegistryName(id));
        }
        return potion;
    }

    public static SoundEvent register(IForgeRegistry<SoundEvent> registry, SoundEvent sound, String id) {
        if (registry != null && sound != null && !Strings.isNullOrEmpty((String)id)) {
            registry.register(sound.setRegistryName(id));
            return sound;
        }
        return null;
    }

    public static Effect register(IForgeRegistry<Effect> registry, Effect effect, String id) {
        if (registry != null && effect != null && !Strings.isNullOrEmpty((String)id)) {
            registry.register(effect.setRegistryName(id));
            return effect;
        }
        return null;
    }

    public static Enchantment register(IForgeRegistry<Enchantment> registry, Enchantment enchantment, String id) {
        if (registry != null && enchantment != null && !Strings.isNullOrEmpty((String)id)) {
            registry.register(enchantment.setRegistryName(id));
            return enchantment;
        }
        return null;
    }

    public static <T extends Entity> EntityType register(IForgeRegistry<EntityType<?>> registry, EntityType.IFactory<T> entity, EntityClassification type, String id) {
        if (registry != null && entity != null && !Strings.isNullOrEmpty((String)id)) {
            EntityType entityType = (EntityType)EntityType.Builder.func_220322_a(entity, (EntityClassification)type).func_206830_a(id).setRegistryName(id);
            registry.register((IForgeRegistryEntry)entityType);
            return entityType;
        }
        return null;
    }

    public static TileEntityType register(IForgeRegistry<TileEntityType<?>> registry, Supplier<? extends TileEntity> tile, String id, Block ... validBlocks) {
        return RegistryHelper.register(registry, tile, id, null, validBlocks);
    }

    public static TileEntityType register(IForgeRegistry<TileEntityType<?>> registry, Supplier<? extends TileEntity> tile, String id, Type<?> datafixerType, Block ... validBlocks) {
        if (registry != null && tile != null && !Strings.isNullOrEmpty((String)id)) {
            TileEntityType type = (TileEntityType)TileEntityType.Builder.func_223042_a(tile, (Block[])validBlocks).func_206865_a(datafixerType).setRegistryName(id);
            registry.register((IForgeRegistryEntry)type);
            return type;
        }
        return null;
    }
}

