/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;

public class Materials {
    public static final Material IMMOVABLE_OPAQUE = new Builder(MaterialColor.field_151667_k).setPushReaction(PushReaction.IGNORE).isOpaque(true).build();
    public static final Material IMMOVABLE_TRANSLUCENT = new Builder(MaterialColor.field_151667_k).setPushReaction(PushReaction.IGNORE).isOpaque(false).build();

    public static class Builder {
        private final MaterialColor color;
        private boolean isLiquid;
        private boolean isSolid;
        private boolean blocksMovement;
        private boolean isOpaque;
        private boolean isFlammable;
        private boolean isReplaceable;
        private PushReaction pushReaction;

        public Builder(MaterialColor color) {
            this.color = color;
            this.isLiquid = false;
            this.isSolid = true;
            this.blocksMovement = true;
            this.isOpaque = true;
            this.isFlammable = false;
            this.isReplaceable = false;
            this.pushReaction = PushReaction.NORMAL;
        }

        public Builder isLiquid(boolean isLiquid) {
            this.isLiquid = isLiquid;
            return this;
        }

        public Builder isSolid(boolean isSolid) {
            this.isSolid = isSolid;
            return this;
        }

        public Builder blocksMovement(boolean blocksMovement) {
            this.blocksMovement = blocksMovement;
            return this;
        }

        public Builder isOpaque(boolean isOpaque) {
            this.isOpaque = isOpaque;
            return this;
        }

        public Builder isFlammable(boolean isFlammable) {
            this.isFlammable = isFlammable;
            return this;
        }

        public Builder isReplaceable(boolean isReplaceable) {
            this.isReplaceable = isReplaceable;
            return this;
        }

        public Builder setPushReaction(PushReaction reaction) {
            this.pushReaction = reaction;
            return this;
        }

        public Material build() {
            return new Material(this.color, this.isLiquid, this.isSolid, this.blocksMovement, this.isOpaque, this.isFlammable, this.isReplaceable, this.pushReaction);
        }
    }
}

