/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import shetiphian.core.ShetiPhianCore;

public class HitBoxData {
    private static List<ResourceLocation> ERROR_SHOWN = new ArrayList<ResourceLocation>();
    private static IReloadableResourceManager resourceManager = null;
    private static final CompletableFuture<Unit> RESOURCE_RELOAD_INIT_TASK = CompletableFuture.completedFuture(Unit.INSTANCE);

    public static void initialize() {
        if (resourceManager == null) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
                resourceManager = new SimpleReloadableResourceManager(ResourcePackType.SERVER_DATA);
                List list = Minecraft.func_71410_x().func_195548_H().func_198980_d().stream().map(ResourcePackInfo::func_195796_e).collect(Collectors.toList());
                resourceManager.func_219537_a(Util.func_215072_e(), (Executor)Minecraft.func_71410_x(), RESOURCE_RELOAD_INIT_TASK, list);
            });
            DistExecutor.runWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> {
                if (ServerLifecycleHooks.getCurrentServer() != null) {
                    resourceManager = (IReloadableResourceManager)ServerLifecycleHooks.getCurrentServer().getDataPackRegistries().func_240970_h_();
                }
            });
        }
    }

    @Deprecated
    public static InputStream getResource(ResourceLocation location) {
        return HitBoxData.getResource(location, false);
    }

    @Deprecated
    public static InputStream getResource(ResourceLocation location, boolean file_check) {
        if (resourceManager == null) {
            HitBoxData.initialize();
        }
        if (resourceManager != null && !resourceManager.func_199001_a().isEmpty()) {
            InputStream stream;
            block4: {
                stream = null;
                try {
                    stream = resourceManager.func_199002_a(location).func_199027_b();
                }
                catch (Exception error) {
                    if (file_check || ERROR_SHOWN.contains(location)) break block4;
                    error.printStackTrace();
                    ERROR_SHOWN.add(location);
                }
            }
            return stream;
        }
        return null;
    }

    @Deprecated
    public static Table<String, Direction, VoxelShape> load(ResourceLocation resource) {
        return HitBoxData.load(resource, false);
    }

    @Deprecated
    public static Table<String, Direction, VoxelShape> load(ResourceLocation resource, boolean orientedDown) {
        Map json = null;
        InputStream inputStream = HitBoxData.getResource(resource);
        if (inputStream != null) {
            try {
                String data = new String(ByteStreams.toByteArray((InputStream)inputStream), StandardCharsets.UTF_8);
                inputStream.close();
                json = (Map)new Gson().fromJson(data, Map.class);
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
        HashBasedTable table = HashBasedTable.create();
        if (json != null) {
            for (Map.Entry entry : json.entrySet()) {
                String key = (String)entry.getKey();
                Object entryValue = entry.getValue();
                if (!(entryValue instanceof ArrayList)) continue;
                ArrayList entryList = (ArrayList)entryValue;
                if (entryList.get(0) instanceof Double) {
                    if (entryList.size() == 6) {
                        Map<Direction, VoxelShape> values = HitBoxData.getValues(orientedDown, (Double)entryList.get(0), (Double)entryList.get(1), (Double)entryList.get(2), (Double)entryList.get(3), (Double)entryList.get(4), (Double)entryList.get(5));
                        for (Map.Entry<Object, Object> entry2 : values.entrySet()) {
                            table.put((Object)key, entry2.getKey(), entry2.getValue());
                        }
                        continue;
                    }
                    ShetiPhianCore.LOGGER.error("Skipping Entry '" + key + "' from file '" + resource.toString() + "', six doubles are required in the array [x1,y1,z1,x2,y2,z2]");
                    continue;
                }
                if (!(entryList.get(0) instanceof ArrayList)) continue;
                HashMap<Direction, List> shapeMap = new HashMap<Direction, List>();
                for (int index = 0; index < entryList.size(); ++index) {
                    ArrayList list;
                    Object e = entryList.get(index);
                    if (!(e instanceof ArrayList) || !((list = (ArrayList)e).get(0) instanceof Double)) continue;
                    if (list.size() == 6) {
                        Map<Direction, VoxelShape> values = HitBoxData.getValues(orientedDown, (Double)list.get(0), (Double)list.get(1), (Double)list.get(2), (Double)list.get(3), (Double)list.get(4), (Double)list.get(5));
                        for (Map.Entry<Direction, VoxelShape> value : values.entrySet()) {
                            List shapeList = shapeMap.getOrDefault(value.getKey(), new ArrayList());
                            shapeList.add(value.getValue());
                            shapeMap.put(value.getKey(), shapeList);
                        }
                        continue;
                    }
                    ShetiPhianCore.LOGGER.error("Skipping Entry #" + index + " in '" + key + "' from file '" + resource.toString() + "', six doubles are required in the array [x1,y1,z1,x2,y2,z2]");
                }
                for (Map.Entry entry3 : shapeMap.entrySet()) {
                    List shapeList = (List)entry3.getValue();
                    VoxelShape[] voxels = new VoxelShape[shapeList.size() - 1];
                    for (int index = 0; index < voxels.length; ++index) {
                        voxels[index] = (VoxelShape)shapeList.get(index + 1);
                    }
                    VoxelShape voxelShape = VoxelShapes.func_216384_a((VoxelShape)((VoxelShape)shapeList.get(0)), (VoxelShape[])voxels);
                    table.put((Object)key, entry3.getKey(), (Object)voxelShape);
                }
            }
        }
        return table;
    }

    public static Map<Direction, VoxelShape> build(double[][] cordsets, boolean orientedDown) {
        HashMap<Direction, VoxelShape> voxelShapeMap = new HashMap<Direction, VoxelShape>();
        HashMap<Direction, List> shapeMap = new HashMap<Direction, List>();
        for (double[] cords : cordsets) {
            if (cords.length != 6) continue;
            Map<Direction, VoxelShape> values = HitBoxData.getValues(orientedDown, cords);
            for (Map.Entry<Direction, VoxelShape> value : values.entrySet()) {
                List shapeList = shapeMap.getOrDefault(value.getKey(), new ArrayList());
                shapeList.add(value.getValue());
                shapeMap.put(value.getKey(), shapeList);
            }
        }
        Object object = shapeMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry shapeEntry = (Map.Entry)object.next();
            List shapeList = (List)shapeEntry.getValue();
            VoxelShape[] voxels = new VoxelShape[shapeList.size() - 1];
            for (int index = 0; index < voxels.length; ++index) {
                voxels[index] = (VoxelShape)shapeList.get(index + 1);
            }
            VoxelShape voxelShape = VoxelShapes.func_216384_a((VoxelShape)((VoxelShape)shapeList.get(0)), (VoxelShape[])voxels);
            voxelShapeMap.put((Direction)shapeEntry.getKey(), voxelShape);
        }
        return voxelShapeMap;
    }

    private static Map<Direction, VoxelShape> getValues(boolean orientedDown, double ... cords) {
        HashMap<Direction, VoxelShape> map = new HashMap<Direction, VoxelShape>();
        if (orientedDown) {
            map.put(Direction.DOWN, Block.func_208617_a((double)cords[0], (double)cords[1], (double)cords[2], (double)cords[3], (double)cords[4], (double)cords[5]));
            map.put(Direction.UP, Block.func_208617_a((double)cords[0], (double)(16.0 - cords[4]), (double)(16.0 - cords[5]), (double)cords[3], (double)(16.0 - cords[1]), (double)(16.0 - cords[2])));
            cords = new double[]{cords[0], 16.0 - cords[5], cords[1], cords[3], 16.0 - cords[2], cords[4]};
        } else {
            map.put(Direction.DOWN, Block.func_208617_a((double)cords[0], (double)cords[2], (double)(16.0 - cords[4]), (double)cords[3], (double)cords[5], (double)(16.0 - cords[1])));
            map.put(Direction.UP, Block.func_208617_a((double)cords[0], (double)(16.0 - cords[5]), (double)cords[1], (double)cords[3], (double)(16.0 - cords[2]), (double)cords[4]));
        }
        map.put(Direction.NORTH, Block.func_208617_a((double)cords[0], (double)cords[1], (double)cords[2], (double)cords[3], (double)cords[4], (double)cords[5]));
        map.put(Direction.SOUTH, Block.func_208617_a((double)(16.0 - cords[3]), (double)cords[1], (double)(16.0 - cords[5]), (double)(16.0 - cords[0]), (double)cords[4], (double)(16.0 - cords[2])));
        map.put(Direction.WEST, Block.func_208617_a((double)cords[5], (double)cords[1], (double)(16.0 - cords[0]), (double)cords[2], (double)cords[4], (double)(16.0 - cords[3])));
        map.put(Direction.EAST, Block.func_208617_a((double)(16.0 - cords[2]), (double)cords[1], (double)cords[0], (double)(16.0 - cords[5]), (double)cords[4], (double)cords[3]));
        return map;
    }
}

