/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CapabilityHelper {
    public static FluidHelper FLUIDS = new FluidHelper();
    public static ItemHelper ITEMS = new ItemHelper();
    public static ComparatorHelper COMPARATOR = new ComparatorHelper();

    public static class ComparatorHelper {
        public int getInputOverride(IFluidHandler handler) {
            if (handler != null) {
                int fluidCount = 0;
                float fullness = 0.0f;
                int tankCount = handler.getTanks();
                for (int tank = 0; tank < tankCount; ++tank) {
                    FluidStack stack = handler.getFluidInTank(tank);
                    if (stack == FluidStack.EMPTY || stack.getAmount() <= 0) continue;
                    fullness += (float)stack.getAmount() / (float)handler.getTankCapacity(tank);
                    ++fluidCount;
                }
                return MathHelper.func_76141_d((float)((fullness /= (float)tankCount) * 14.0f)) + (fluidCount > 0 ? 1 : 0);
            }
            return 0;
        }

        public int getInputOverride(IItemHandler handler) {
            if (handler != null) {
                int itemCount = 0;
                float fullness = 0.0f;
                for (int slot = 0; slot < handler.getSlots(); ++slot) {
                    ItemStack stack = handler.getStackInSlot(slot);
                    if (stack.func_190926_b()) continue;
                    fullness += (float)stack.func_190916_E() / (float)Math.min(handler.getSlotLimit(slot), stack.func_77976_d());
                    ++itemCount;
                }
                return MathHelper.func_76141_d((float)((fullness /= (float)handler.getSlots()) * 14.0f)) + (itemCount > 0 ? 1 : 0);
            }
            return 0;
        }

        public int getInputOverride(TileEntity tile) {
            if (tile != null) {
                IFluidHandler fluidHandler;
                int counter = 0;
                float value = 0.0f;
                IItemHandler itemHandler = ITEMS.getHandler(tile, null);
                if (itemHandler != null) {
                    value += (float)this.getInputOverride(itemHandler) / 15.0f;
                    ++counter;
                }
                if ((fluidHandler = FLUIDS.getHandler(tile, null)) != null) {
                    value += (float)this.getInputOverride(fluidHandler) / 15.0f;
                    ++counter;
                }
                if (counter > 0) {
                    return MathHelper.func_76141_d((float)(value / (float)counter * 14.0f)) + (value > 0.0f ? 1 : 0);
                }
            }
            return 0;
        }

        public int getInputOverride(IWorld world, BlockPos pos) {
            return world == null || pos == null ? 0 : this.getInputOverride(world.func_175625_s(pos));
        }
    }

    public static class ItemHelper {
        public boolean isItemContainer(ItemStack stack, Direction facing) {
            return !stack.func_190926_b() && this.getHandler(stack, facing) != null;
        }

        public boolean isItemContainer(TileEntity tile, Direction facing) {
            return tile != null && this.getHandler(tile, facing) != null;
        }

        public boolean isItemContainer(IWorld world, BlockPos pos, Direction facing) {
            return world != null && pos != null && this.getHandler(world, pos, facing) != null;
        }

        @Nullable
        public IItemHandler getHandler(ItemStack stack, Direction facing) {
            return stack.func_190926_b() ? null : (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).orElse(null);
        }

        @Nullable
        public IItemHandler getHandler(TileEntity tile, Direction facing) {
            return tile == null ? null : (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).orElse(null);
        }

        @Nullable
        public IItemHandler getHandler(IWorld world, BlockPos pos, Direction facing) {
            return world == null || pos == null ? null : this.getHandler(world.func_175625_s(pos), facing);
        }
    }

    public static class FluidHelper {
        public boolean isFluidContainer(ItemStack stack, Direction facing) {
            return !stack.func_190926_b() && this.getHandler(stack, facing) != null;
        }

        public boolean isFluidContainer(TileEntity tile, Direction facing) {
            return tile != null && this.getHandler(tile, facing) != null;
        }

        public boolean isFluidContainer(IWorld world, BlockPos pos, Direction facing) {
            return world != null && pos != null && this.getHandler(world, pos, facing) != null;
        }

        @Nullable
        public IFluidHandler getHandler(ItemStack stack, Direction facing) {
            LazyOptional instHandlerItem;
            IFluidHandler handler = null;
            if (!stack.func_190926_b() && (handler = (IFluidHandler)(instHandlerItem = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, facing)).orElse(null)) == null) {
                LazyOptional instHandler = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
                handler = (IFluidHandler)instHandler.orElse(null);
            }
            return handler;
        }

        @Nullable
        public IFluidHandler getHandler(TileEntity tile, Direction facing) {
            return tile == null ? null : (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing).orElse(null);
        }

        @Nullable
        public IFluidHandler getHandler(IWorld world, BlockPos pos, Direction facing) {
            TileEntity tileEntity;
            BlockState state;
            Block block;
            if (world != null && pos != null && (block = (state = world.func_180495_p(pos)).func_177230_c()).hasTileEntity(state) && (tileEntity = world.func_175625_s(pos)) != null) {
                return (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing).orElse(null);
            }
            return null;
        }
    }
}

