/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.gui;

import com.google.common.base.Strings;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import shetiphian.core.client.GuiFunctions;
import shetiphian.core.client.Localization;
import shetiphian.core.client.gui.ButtonIcon;
import shetiphian.core.client.gui.WidgetInfoBox;
import shetiphian.core.common.inventory.ISidedWrapper;
import shetiphian.core.common.inventory.SidedContainer;
import shetiphian.core.internal.network.NetworkHandler;
import shetiphian.core.internal.network.PacketSidedWrapper;

@OnlyIn(value=Dist.CLIENT)
public abstract class GuiSidedContainer<T extends SidedContainer<?>>
extends ContainerScreen<T> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("shetiphiancore", "textures/gui/info_config.png");
    protected Mode mode = Mode.NORMAL;
    protected WidgetInfoBox infoBox;
    protected byte[] indexSide = new byte[]{-1, -1, -1, -1, -1, -1};
    protected String[] faceNames;
    protected String[] invNames;
    protected Button hoveredButton;
    protected int hoverTime;
    private Button buttonSave;

    public GuiSidedContainer(T container, boolean rotatable, PlayerInventory inventory, ITextComponent title) {
        super(container, inventory, title);
        String[] stringArray;
        if (rotatable) {
            String[] stringArray2 = new String[6];
            stringArray2[0] = "bottom";
            stringArray2[1] = "top";
            stringArray2[2] = "back";
            stringArray2[3] = "front";
            stringArray2[4] = "left";
            stringArray = stringArray2;
            stringArray2[5] = "right";
        } else {
            String[] stringArray3 = new String[6];
            stringArray3[0] = "down";
            stringArray3[1] = "up";
            stringArray3[2] = "north";
            stringArray3[3] = "south";
            stringArray3[4] = "west";
            stringArray = stringArray3;
            stringArray3[5] = "east";
        }
        this.faceNames = stringArray;
    }

    protected abstract List<String> getInfoBoxText();

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        switch (this.mode) {
            case NORMAL: {
                this.field_230710_m_.add(new ButtonMode(this.field_147003_i - 18, this.field_147009_r + 16, Mode.INFO));
                this.field_230710_m_.add(new ButtonMode(this.field_147003_i - 18, this.field_147009_r + 40, Mode.CONFIG));
                this.initSidedContainer();
                break;
            }
            case INFO: {
                this.field_230710_m_.add(new ButtonMode(this.field_147003_i - 18, this.field_147009_r + 16, Mode.NORMAL));
                this.field_230710_m_.add(new ButtonMode(this.field_147003_i - 18, this.field_147009_r + 40, Mode.CONFIG));
                this.infoBox = new WidgetInfoBox(this.field_230706_i_, this.field_147003_i + 13, this.field_147009_r + this.field_147000_g - 84, 158, 72).addHeader(this.getInfoBoxText());
                break;
            }
            case CONFIG: {
                this.field_230710_m_.add(new ButtonMode(this.field_147003_i - 18, this.field_147009_r + 16, Mode.NORMAL));
                this.field_230710_m_.add(new ButtonMode(this.field_147003_i - 18, this.field_147009_r + 40, Mode.INFO));
                this.buttonSave = new ButtonSave(this.field_147003_i + 158, this.field_147009_r + this.field_147000_g - 88);
                this.field_230710_m_.add(this.buttonSave);
                if (((SidedContainer)this.field_147002_h).getTile() != null) {
                    this.indexSide = (byte[])((SidedContainer)this.field_147002_h).getSidedWrapper().getIndexes().clone();
                }
                int x = this.field_147003_i + 91;
                int y = this.field_147009_r + this.field_147000_g - 48;
                this.field_230710_m_.add(new ButtonFace(x + 1, y - 11, 22, 22, Direction.EAST));
                this.field_230710_m_.add(new ButtonFace(x - 47, y - 11, 22, 22, Direction.WEST));
                this.field_230710_m_.add(new ButtonFace(x - 23, y - 11, 22, 22, Direction.SOUTH));
                this.field_230710_m_.add(new ButtonFace(x + 25, y - 11, 22, 22, Direction.NORTH));
                this.field_230710_m_.add(new ButtonFace(x - 23, y - 35, 22, 22, Direction.UP));
                this.field_230710_m_.add(new ButtonFace(x - 23, y + 13, 22, 22, Direction.DOWN));
            }
        }
    }

    private String getFaceText(int index) {
        String text = Localization.get("info." + this.faceNames[index]);
        return text.substring(0, 1).toUpperCase();
    }

    protected abstract void initSidedContainer();

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        if (this.mode == Mode.NORMAL) {
            super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.func_230459_a_(matrixStack, mouseX, mouseY);
            return;
        }
        this.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        MinecraftForge.EVENT_BUS.post((Event)new GuiContainerEvent.DrawBackground((ContainerScreen)this, matrixStack, mouseX, mouseY));
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableDepthTest();
        Button lastButton = this.hoveredButton;
        this.hoveredButton = null;
        for (Widget widget : this.field_230710_m_) {
            widget.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            if (!(widget instanceof Button) || !widget.func_231047_b_((double)mouseX, (double)mouseY)) continue;
            if (lastButton != widget) {
                this.hoverTime = 0;
            }
            this.hoveredButton = (Button)widget;
        }
        this.hoverTime = this.hoveredButton == null ? 0 : MathHelper.func_76125_a((int)(this.hoverTime + 1), (int)0, (int)Integer.MAX_VALUE);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableRescaleNormal();
        this.func_230451_b_(matrixStack, mouseX, mouseY);
        MinecraftForge.EVENT_BUS.post((Event)new GuiContainerEvent.DrawForeground((ContainerScreen)this, matrixStack, mouseX, mouseY));
        RenderSystem.popMatrix();
        GlStateManager.func_227734_k_();
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        if (this.mode == Mode.NORMAL) {
            this.drawNormal(matrixStack, partialTicks, mouseX, mouseY);
            return;
        }
        this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
        GuiFunctions.enterDrawTextureStateWithBlend();
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r + this.field_147000_g - 98, 0, 158, 182, 98);
        if (this.mode == Mode.INFO) {
            this.func_238474_b_(matrixStack, this.field_147003_i + 12, this.field_147009_r + this.field_147000_g - 85, 0, 84, 160, 74);
        } else {
            this.func_238474_b_(matrixStack, this.buttonSave.field_230690_l_, this.buttonSave.field_230691_m_, 208, 208, this.buttonSave.func_230998_h_(), this.buttonSave.func_238483_d_());
        }
        GuiFunctions.exitDrawTextureStateWithBlend();
        if (this.mode == Mode.INFO) {
            this.drawInfo(matrixStack, partialTicks, mouseX, mouseY);
            this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
            this.func_238474_b_(matrixStack, this.field_147003_i + 12, this.field_147009_r + this.field_147000_g - 92, 12, 164, 160, 8);
            this.func_238474_b_(matrixStack, this.field_147003_i + 12, this.field_147009_r + this.field_147000_g - 85, 0, 84, 160, 1);
            this.func_238474_b_(matrixStack, this.field_147003_i + 12, this.field_147009_r + this.field_147000_g - 12, 0, 157, 160, 1);
            this.func_238474_b_(matrixStack, this.field_147003_i + 12, this.field_147009_r + this.field_147000_g - 11, 12, 245, 160, 8);
        } else {
            this.drawConfig(matrixStack, partialTicks, mouseX, mouseY);
        }
    }

    protected abstract void drawNormal(MatrixStack var1, float var2, int var3, int var4);

    protected abstract void drawInfo(MatrixStack var1, float var2, int var3, int var4);

    protected abstract void drawConfig(MatrixStack var1, float var2, int var3, int var4);

    protected void renderFaceButton(MatrixStack matrixStack, Widget button, Direction face, int mouseX, int mouseY, float partialTicks) {
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.mode == Mode.CONFIG && this.hoverTime >= 40 && this.hoveredButton instanceof ButtonFace) {
            int id = ((ButtonFace)this.hoveredButton).faceIndex;
            byte index = this.indexSide[id];
            ArrayList<StringTextComponent> list = new ArrayList<StringTextComponent>();
            list.add(new StringTextComponent("\u00a7l" + Localization.get("info." + this.faceNames[id])));
            if (this.invNames != null) {
                list.add(new StringTextComponent("\u00a7o" + Localization.get(index > -1 && index < this.invNames.length ? this.invNames[index] : "gui.side_disabled.txt")));
            }
            this.func_243308_b(matrixStack, list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.mode == Mode.INFO && this.infoBox.func_231046_a_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        if (this.mode == Mode.INFO && this.infoBox.func_223281_a_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char character, int value) {
        if (this.mode == Mode.INFO && this.infoBox.func_231042_a_(character, value)) {
            return true;
        }
        return super.func_231042_a_(character, value);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.mode == Mode.INFO && this.infoBox.func_231044_a_(mouseX, mouseY, button)) {
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double accelX, double accelY) {
        if (this.mode == Mode.INFO && this.infoBox.func_231045_a_(mouseX, mouseY, button, accelX, accelY)) {
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, button, accelX, accelY);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        if (this.mode == Mode.INFO && this.infoBox.func_231043_a_(mouseX, mouseY, scroll)) {
            return true;
        }
        return super.func_231043_a_(mouseX, mouseY, scroll);
    }

    private class ButtonFace
    extends ButtonIcon {
        private final GuiSidedContainer<T> parent;
        private final Direction face;
        private final int faceIndex;

        ButtonFace(int posX, int posY, int sizeX, int sizeY, Direction face) {
            super(posX, posY, sizeX, sizeY);
            this.parent = GuiSidedContainer.this;
            this.parent.field_230705_e_.add(this);
            this.face = face;
            this.faceIndex = face.func_176745_a();
            this.setText(this.parent.getFaceText(this.faceIndex));
        }

        @Override
        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (!this.field_230694_p_) {
                return;
            }
            this.parent.renderFaceButton(matrixStack, (Widget)this, this.face, mouseX, mouseY, partialTicks);
            if (!Strings.isNullOrEmpty((String)this.displayString)) {
                ButtonFace.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.parent.field_230712_o_, (String)this.displayString, (int)(this.field_230690_l_ + this.field_230688_j_ / 2), (int)(this.field_230691_m_ + (this.field_230689_k_ - 8) / 2), (int)-1);
            }
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (this.func_230992_c_(mouseX, mouseY)) {
                this.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
                ISidedWrapper.SidedWrapper wrapper = ((ISidedWrapper)((SidedContainer)this.parent.field_147002_h).getTile()).getSidedWrapper();
                byte max = (byte)(wrapper.getWrapperCount() - 1);
                switch (button) {
                    case 0: {
                        int n = this.faceIndex;
                        this.parent.indexSide[n] = (byte)(this.parent.indexSide[n] + 1);
                        if (this.parent.indexSide[this.faceIndex] <= max) break;
                        this.parent.indexSide[this.faceIndex] = -1;
                        break;
                    }
                    case 1: {
                        int n = this.faceIndex;
                        this.parent.indexSide[n] = (byte)(this.parent.indexSide[n] - 1);
                        if (this.parent.indexSide[this.faceIndex] >= -1) break;
                        this.parent.indexSide[this.faceIndex] = max;
                        break;
                    }
                    case 2: {
                        this.parent.indexSide[this.faceIndex] = -1;
                    }
                }
                if (this.parent.buttonSave != null) {
                    ((GuiSidedContainer)this.parent).buttonSave.field_230694_p_ = false;
                    byte[] original = wrapper.getIndexes();
                    for (int index = 0; index < 6; ++index) {
                        if (original[index] == this.parent.indexSide[index]) continue;
                        ((GuiSidedContainer)this.parent).buttonSave.field_230694_p_ = true;
                        break;
                    }
                }
                return true;
            }
            return false;
        }
    }

    private class ButtonSave
    extends ButtonIcon {
        private final GuiSidedContainer<T> parent;

        ButtonSave(int posX, int posY) {
            super(posX, posY, 16, 16, GUI_TEXTURE, 208, 240, 208, 224, 208, 240);
            this.parent = GuiSidedContainer.this;
            this.parent.field_230705_e_.add(this);
            this.field_230694_p_ = false;
        }

        @Override
        public void func_230930_b_() {
            NetworkHandler.sendToServer(new PacketSidedWrapper(((SidedContainer)this.parent.field_147002_h).getTile().func_174877_v(), this.parent.indexSide));
            this.field_230694_p_ = false;
        }
    }

    private class ButtonMode
    extends ButtonIcon {
        private final GuiSidedContainer<T> parent;
        private final Mode mode;

        ButtonMode(int posX, int posY, Mode mode) {
            super(posX, posY, 16, 16, GUI_TEXTURE, mode.normal, mode.hover, mode.pressed);
            this.parent = GuiSidedContainer.this;
            this.parent.field_230705_e_.add(this);
            this.mode = mode;
        }

        @Override
        public void func_230930_b_() {
            this.parent.mode = this.mode;
            this.parent.func_231160_c_();
        }
    }

    protected static enum Mode {
        NORMAL(192, 240, 192, 224, 192, 240),
        INFO(224, 240, 224, 224, 224, 240),
        CONFIG(240, 240, 240, 224, 240, 240);

        private final int[] normal;
        private final int[] hover;
        private final int[] pressed;

        private Mode(int nU, int nV, int hU, int hV, int pU, int pV) {
            this.normal = new int[]{nU, nV};
            this.hover = new int[]{hU, hV};
            this.pressed = new int[]{pU, pV};
        }
    }
}

