/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiFunctions {
    public static GuiPass guiPass = new GuiPass((ITextComponent)new StringTextComponent("PassThroughGUI"));
    private static final Tessellator tessellator = new Tessellator(0x200000);

    public static Tessellator getTessellator() {
        return tessellator;
    }

    private static float[] getPixelScale(int ... imageSize) {
        int width;
        int n = width = imageSize.length >= 1 ? imageSize[0] : 256;
        int height = imageSize.length >= 2 ? imageSize[1] : (imageSize.length == 1 ? width : 256);
        return new float[]{1.0f / (float)width, 1.0f / (float)height};
    }

    public static void enterDrawTextureState() {
        RenderSystem.disableDepthTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void enterDrawTextureStateWithBlend() {
        GuiFunctions.enterDrawTextureState();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
    }

    public static void exitDrawTextureStateWithBlend() {
        RenderSystem.disableBlend();
        GuiFunctions.exitDrawTextureState();
    }

    public static void exitDrawTextureState() {
        RenderSystem.enableDepthTest();
    }

    public static void exitRenderItemState() {
    }

    public static void drawTexture(MatrixStack matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV, float zLevel, int ... imageSize) {
        GuiFunctions.drawTextureScaled(matrixStack, posX, posY, posU, posV, sizeU, sizeV, 1.0, zLevel, imageSize);
    }

    public static void drawTextureScaled(MatrixStack matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV, double scale, float zLevel, int ... imageSize) {
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        float[] pScale = GuiFunctions.getPixelScale(imageSize);
        double[] x = new double[]{posX, posX + (double)sizeU * scale};
        double[] y = new double[]{posY, posY + (double)sizeV * scale};
        float[] u = new float[]{(float)posU * pScale[0], (float)(posU + sizeU) * pScale[0]};
        float[] v = new float[]{(float)posV * pScale[1], (float)(posV + sizeV) * pScale[1]};
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_227888_a_(matrix, (float)x[0], (float)y[1], zLevel).func_225583_a_(u[0], v[1]).func_181675_d();
        renderer.func_227888_a_(matrix, (float)x[1], (float)y[1], zLevel).func_225583_a_(u[1], v[1]).func_181675_d();
        renderer.func_227888_a_(matrix, (float)x[1], (float)y[0], zLevel).func_225583_a_(u[1], v[0]).func_181675_d();
        renderer.func_227888_a_(matrix, (float)x[0], (float)y[0], zLevel).func_225583_a_(u[0], v[0]).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTextureMirrored(MatrixStack matrixStack, int posX, int posY, int posU, int posV, int sizeU, int sizeV, float zLevel, int ... imageSize) {
        GuiFunctions.drawTextureMirroredAndScaled(matrixStack, posX, posY, posU, posV, sizeU, sizeV, 1.0, zLevel, imageSize);
    }

    public static void drawTextureMirroredAndScaled(MatrixStack matrixStack, int posX, int posY, int posU, int posV, int sizeU, int sizeV, double scale, float zLevel, int ... imageSize) {
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        float[] pScale = GuiFunctions.getPixelScale(imageSize);
        double[] x = new double[]{posX, (double)posX + (double)sizeU * scale};
        double[] y = new double[]{posY, (double)posY + (double)sizeV * scale};
        float[] u = new float[]{(float)posU * pScale[0], (float)(posU + sizeU) * pScale[0]};
        float[] v = new float[]{(float)posV * pScale[1], (float)(posV + sizeV) * pScale[1]};
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_227888_a_(matrix, (float)x[0], (float)y[1], zLevel).func_225583_a_(u[1], v[1]).func_181675_d();
        renderer.func_227888_a_(matrix, (float)x[1], (float)y[1], zLevel).func_225583_a_(u[0], v[1]).func_181675_d();
        renderer.func_227888_a_(matrix, (float)x[1], (float)y[0], zLevel).func_225583_a_(u[0], v[0]).func_181675_d();
        renderer.func_227888_a_(matrix, (float)x[0], (float)y[0], zLevel).func_225583_a_(u[1], v[0]).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTextureInverted(MatrixStack matrixStack, int posX, int posY, int posU, int posV, int sizeU, int sizeV, float zLevel, int ... imageSize) {
        GuiFunctions.drawTextureInvertedAndScaled(matrixStack, posX, posY, posU, posV, sizeU, sizeV, 1.0, zLevel, imageSize);
    }

    public static void drawTextureInvertedAndScaled(MatrixStack matrixStack, int posX, int posY, int posU, int posV, int sizeU, int sizeV, double scale, float zLevel, int ... imageSize) {
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        float[] pScale = GuiFunctions.getPixelScale(imageSize);
        double[] x = new double[]{posX, (double)posX + (double)sizeU * scale};
        double[] y = new double[]{posY, (double)posY + (double)sizeV * scale};
        float[] u = new float[]{(float)posU * pScale[0], (float)(posU + sizeU) * pScale[0]};
        float[] v = new float[]{(float)posV * pScale[1], (float)(posV + sizeV) * pScale[1]};
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_227888_a_(matrix, (float)x[0], (float)y[1], zLevel).func_225583_a_(u[0], v[0]).func_181675_d();
        renderer.func_227888_a_(matrix, (float)x[1], (float)y[1], zLevel).func_225583_a_(u[1], v[0]).func_181675_d();
        renderer.func_227888_a_(matrix, (float)x[1], (float)y[0], zLevel).func_225583_a_(u[1], v[1]).func_181675_d();
        renderer.func_227888_a_(matrix, (float)x[0], (float)y[0], zLevel).func_225583_a_(u[0], v[1]).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawHorizontalGradient(MatrixStack matrixStack, double left, double top, double right, double bottom, float zLevel, int colorRight, int colorLeft) {
        GuiFunctions.drawGradientRect(matrixStack, left, top, right, bottom, zLevel, colorRight, colorLeft, colorLeft, colorRight);
    }

    public static void drawGradientRect(MatrixStack matrixStack, double left, double top, double right, double bottom, float zLevel, int colorTop, int colorBottom) {
        GuiFunctions.drawGradientRect(matrixStack, left, top, right, bottom, zLevel, colorTop, colorTop, colorBottom, colorBottom);
    }

    public static void drawRect(MatrixStack matrixStack, double left, double top, double right, double bottom, float zLevel, int color) {
        GuiFunctions.drawGradientRect(matrixStack, left, top, right, bottom, zLevel, color, color, color, color);
    }

    public static void drawGradientRect(MatrixStack matrixStack, double left, double top, double right, double bottom, float zLevel, int colorTopRight, int colorTopLeft, int colorBottomLeft, int colorBottomRight) {
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.shadeModel((int)7425);
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        GuiFunctions.addColoredVertex(matrix, renderer, right, top, zLevel, colorTopRight);
        GuiFunctions.addColoredVertex(matrix, renderer, left, top, zLevel, colorTopLeft);
        GuiFunctions.addColoredVertex(matrix, renderer, left, bottom, zLevel, colorBottomLeft);
        GuiFunctions.addColoredVertex(matrix, renderer, right, bottom, zLevel, colorBottomRight);
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    private static void addColoredVertex(Matrix4f matrix, BufferBuilder renderer, double x, double y, float zLevel, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        renderer.func_227888_a_(matrix, (float)x, (float)y, zLevel).func_227885_a_(red, green, blue, alpha).func_181675_d();
    }

    public static void drawTexturedPane(MatrixStack matrixStack, double posX, double posY, double sizeX, double sizeY, int posU, int posV, int sizeU, int sizeV, float zLevel, int ... imageSize) {
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        float[] pScale = GuiFunctions.getPixelScale(imageSize);
        double[] x = new double[]{posX, posX + sizeX};
        double[] y = new double[]{posY, posY + sizeY};
        float[] u = new float[]{(float)posU * pScale[0], (float)(posU + sizeU) * pScale[0]};
        float[] v = new float[]{(float)posV * pScale[1], (float)(posV + sizeV) * pScale[1]};
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_227888_a_(matrix, (float)x[0], (float)y[1], zLevel).func_225583_a_(u[0], v[1]).func_181675_d();
        renderer.func_227888_a_(matrix, (float)x[1], (float)y[1], zLevel).func_225583_a_(u[1], v[1]).func_181675_d();
        renderer.func_227888_a_(matrix, (float)x[1], (float)y[0], zLevel).func_225583_a_(u[1], v[0]).func_181675_d();
        renderer.func_227888_a_(matrix, (float)x[0], (float)y[0], zLevel).func_225583_a_(u[0], v[0]).func_181675_d();
        tessellator.func_78381_a();
    }

    public static class GuiPass
    extends Screen {
        protected GuiPass(ITextComponent p_i51108_1_) {
            super(p_i51108_1_);
        }

        public void setZLevel(float zLevel) {
            if (this.field_230707_j_ != null) {
                this.field_230707_j_.field_77023_b = zLevel;
            }
        }

        public void func_238468_a_(MatrixStack matrixStack, int x1, int y1, int x2, int y2, int color1, int color2) {
            super.func_238468_a_(matrixStack, x1, y1, x2, y2, color1, color2);
        }
    }
}

