/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core;

import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.config.ModConfig;
import shetiphian.core.common.network.PacketPlayerConfig;
import shetiphian.core.internal.Values;
import shetiphian.core.internal.network.NetworkHandler;

public class Configuration {
    private static final ForgeConfigSpec.Builder BUILDER_CLIENT = new ForgeConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER_CLIENT);
    static final ForgeConfigSpec SPEC_CLIENT = BUILDER_CLIENT.build();

    @SubscribeEvent
    public static void onReLoad(ModConfig.Reloading event) {
        ModConfig config = event.getConfig();
        if (config.getType() == ModConfig.Type.CLIENT) {
            Configuration.sync();
        }
    }

    public static void sync() {
        if (NetworkHandler.isLoaded()) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.func_71410_x().execute(() -> {
                try {
                    NetworkHandler.sendToServer(PacketPlayerConfig.sync(Values.keyConfigUseColorBlend, (Boolean)Configuration.GENERAL.useColorBlendMode.get()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }));
        }
    }

    public static class General {
        public ForgeConfigSpec.BooleanValue useColorBlendMode;

        General(ForgeConfigSpec.Builder builder) {
            this.useColorBlendMode = builder.comment(new String[]{"Adjust the default way RGB16 handles dyes", "True = RYB blending is used to mix the colors", " > Like mixing paint, the dye will be added to the existing color", " > Sneak-Click to set to dye color", " ", "False = Direct RGB value manipulation", " > Click to increase, Sneak-Click to decrease", " ", "RYB is easier to use but RGB is more precise"}).define("use_color_blend_mode", true);
        }
    }
}

