/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.example.map;

import java.util.Objects;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.example.map.ExampleReg;
import net.mehvahdjukaar.selene.map.CustomDecoration;
import net.mehvahdjukaar.selene.map.markers.MapWorldMarker;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;

public class ExampleMarker
extends MapWorldMarker<CustomDecoration> {
    @Nullable
    private ITextComponent name;

    public ExampleMarker() {
        super(ExampleReg.EXAMPLE_DECORATION_TYPE);
    }

    public ExampleMarker(BlockPos pos, ITextComponent name) {
        this();
        this.setPos(pos);
        this.name = name;
    }

    @Override
    public CompoundNBT saveToNBT(CompoundNBT compound) {
        super.saveToNBT(compound);
        if (this.name != null) {
            compound.func_74778_a("Name", ITextComponent.Serializer.func_150696_a((ITextComponent)this.name));
        }
        return compound;
    }

    @Override
    public void loadFromNBT(CompoundNBT compound) {
        super.loadFromNBT(compound);
        this.name = compound.func_74764_b("Name") ? ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("Name")) : null;
    }

    @Nullable
    public static ExampleMarker getFromWorld(IBlockReader world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof SignTileEntity) {
            SignTileEntity sign = (SignTileEntity)tileentity;
            ITextComponent name = sign.func_212366_a(0);
            return new ExampleMarker(pos, name);
        }
        return null;
    }

    @Override
    @Nullable
    public CustomDecoration doCreateDecoration(byte mapX, byte mapY, byte rot) {
        return new CustomDecoration(this.getType(), mapX, mapY, rot, this.name);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            ExampleMarker marker = (ExampleMarker)other;
            return Objects.equals(this.getPos(), marker.getPos()) && Objects.equals(this.name, marker.name);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getPos(), this.name);
    }

    @Override
    public boolean shouldUpdate(MapWorldMarker<?> other) {
        if (other instanceof ExampleMarker) {
            return !Objects.equals(this.name, ((ExampleMarker)other).name);
        }
        return false;
    }

    @Override
    public void updateDecoration(CustomDecoration old) {
        old.setDisplayName(this.name);
    }
}

