/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.server.items;

import com.wynprice.secretrooms.server.blocks.SecretBaseBlock;
import com.wynprice.secretrooms.server.data.SecretData;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class SwitchProbe
extends Item {
    public static final String PROBE_HIT_DATA = "probe_hit_data";

    public SwitchProbe(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        Optional<SecretData> data = SecretBaseBlock.getMirrorData((IBlockReader)context.func_195991_k(), context.func_195995_a());
        if (data.isPresent()) {
            CompoundNBT compound = stack.func_196082_o().func_74775_l(PROBE_HIT_DATA);
            if (!compound.isEmpty()) {
                SecretData d = new SecretData(null);
                d.readNBT(compound);
                data.get().setFrom(d);
                BlockState blockState = context.func_195991_k().func_180495_p(context.func_195995_a());
                if (blockState.func_235901_b_((Property)BlockStateProperties.field_208198_y) && d.getBlockState().func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                    d.setBlockState((BlockState)d.getBlockState().func_206870_a((Property)BlockStateProperties.field_208198_y, blockState.func_177229_b((Property)BlockStateProperties.field_208198_y)));
                }
            }
        } else {
            SecretData d = new SecretData(null);
            d.setBlockState(context.func_195991_k().func_180495_p(context.func_195995_a()));
            TileEntity tileEntity = context.func_195991_k().func_175625_s(context.func_195995_a());
            d.setTileEntityNBT(tileEntity != null ? tileEntity.serializeNBT() : null);
            d.writeNBT(stack.func_190925_c(PROBE_HIT_DATA));
        }
        return ActionResultType.SUCCESS;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> text, ITooltipFlag flag) {
        CompoundNBT compound = stack.func_196082_o().func_74775_l(PROBE_HIT_DATA);
        text.add((ITextComponent)new TranslationTextComponent("secretroomsmod.probe.containedblock").func_240699_a_(TextFormatting.GOLD));
        if (compound.isEmpty()) {
            text.add((ITextComponent)new TranslationTextComponent("secretroomsmod.probe.noneset"));
        } else if (Screen.func_231173_s_()) {
            SecretData data = new SecretData(null);
            data.readNBT(compound);
            BlockState state = data.getBlockState();
            text.add((ITextComponent)new TranslationTextComponent("secretroomsmod.probe.data").func_240699_a_(TextFormatting.BLUE));
            text.add((ITextComponent)new TranslationTextComponent("secretroomsmod.probe.blockset", new Object[]{state.func_177230_c().getRegistryName()}).func_240699_a_(TextFormatting.AQUA));
            for (Property property : state.func_235904_r_()) {
                text.add((ITextComponent)new TranslationTextComponent("secretroomsmod.probe.blockproperty", new Object[]{property.func_177701_a(), SwitchProbe.propertyString(property, state.func_177229_b(property))}).func_240699_a_(TextFormatting.DARK_AQUA));
            }
        }
    }

    private static <T extends Comparable<T>> String propertyString(Property<T> property, Comparable<?> value) {
        return property.func_177702_a(value);
    }
}

