/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.server.data;

import com.wynprice.secretrooms.SecretRooms6;
import com.wynprice.secretrooms.server.blocks.SecretBaseBlock;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SecretData {
    private final TileEntity base;
    private BlockState blockState = Blocks.field_150348_b.func_176223_P();
    @Nullable
    private CompoundNBT tileEntityNBT = null;
    private TileEntity tileEntityCache;

    public SecretData(TileEntity base) {
        this.base = base;
    }

    public CompoundNBT writeNBT(CompoundNBT tag) {
        tag.func_218657_a("blockstate", (INBT)NBTUtil.func_190009_a((BlockState)this.getBlockState()));
        if (this.tileEntityNBT != null) {
            tag.func_218657_a("tile_data", (INBT)this.tileEntityNBT);
        }
        return tag;
    }

    public void readNBT(CompoundNBT tag) {
        this.setBlockState(NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l("blockstate")));
        this.setTileEntityNBT(tag.func_74775_l("tile_data"));
    }

    public TileEntity getTileEntityCache() {
        if (this.tileEntityNBT != null && this.tileEntityCache == null) {
            this.tileEntityCache = TileEntity.func_235657_b_((BlockState)this.blockState, (CompoundNBT)this.tileEntityNBT);
            if (this.tileEntityCache != null) {
                if (this.base != null) {
                    this.tileEntityCache.func_174878_a(this.base.func_174877_v());
                    this.tileEntityCache.func_226984_a_(this.base.func_145831_w(), this.base.func_174877_v());
                }
                this.tileEntityCache.field_195045_e = this.blockState;
            } else {
                SecretRooms6.LOGGER.warn("Unable to create Block Entity with id {}. Disregarding it from future references ", (Object)this.tileEntityNBT.func_74779_i("id"));
                this.tileEntityNBT = null;
            }
        }
        return this.tileEntityCache;
    }

    public void setFrom(SecretData data) {
        this.setBlockState(data.getBlockState());
        this.setTileEntityNBT(data.getTileEntityNBT());
    }

    public void setBlockState(BlockState blockState) {
        this.blockState = blockState;
        this.onChanged();
    }

    public BlockState getBlockState() {
        if (this.blockState.func_177230_c() instanceof SecretBaseBlock || this.base != null && this.blockState.isAir((IBlockReader)this.base.func_145831_w(), this.base.func_174877_v())) {
            this.blockState = Blocks.field_150348_b.func_176223_P();
        }
        return this.blockState;
    }

    public void setTileEntityNBT(@Nullable CompoundNBT tileEntityNBT) {
        this.tileEntityNBT = tileEntityNBT != null && tileEntityNBT.isEmpty() ? null : tileEntityNBT;
        this.tileEntityCache = null;
        this.onChanged();
    }

    private void onChanged() {
        if (this.base != null && this.base.func_145831_w() != null) {
            World world = this.base.func_145831_w();
            if (world.field_72995_K) {
                this.base.requestModelDataUpdate();
                world.func_184138_a(this.base.func_174877_v(), this.base.func_195044_w(), this.base.func_195044_w(), 11);
            } else {
                SUpdateTileEntityPacket supdatetileentitypacket = this.base.func_189518_D_();
                for (ServerPlayerEntity player : ((ServerWorld)world).func_217369_A()) {
                    if (supdatetileentitypacket == null) continue;
                    player.field_71135_a.func_147359_a((IPacket)supdatetileentitypacket);
                }
            }
            world.func_72863_F().func_212863_j_().func_215568_a(this.base.func_174877_v());
        }
    }

    @Nullable
    public CompoundNBT getTileEntityNBT() {
        return this.tileEntityNBT;
    }
}

