/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.server.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.wynprice.secretrooms.SecretRooms6;
import com.wynprice.secretrooms.server.blocks.SecretBlocks;
import com.wynprice.secretrooms.server.items.SecretItems;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class SecretBlockLootTableProvider
implements IDataProvider {
    private final DataGenerator dataGenerator;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public SecretBlockLootTableProvider(DataGenerator dataGenerator) {
        this.dataGenerator = dataGenerator;
    }

    public void func_200398_a(DirectoryCache directoryCache) {
        Path folder = this.dataGenerator.func_200391_b();
        HashMap loot = Maps.newHashMap();
        SecretBlockLootTableProvider.createBlockDrop(SecretBlocks.GHOST_BLOCK, loot);
        SecretBlockLootTableProvider.createBlockDrop(SecretBlocks.SECRET_STAIRS, loot);
        SecretBlockLootTableProvider.createBlockDrop(SecretBlocks.SECRET_LEVER, loot);
        SecretBlockLootTableProvider.createBlockDrop(SecretBlocks.SECRET_REDSTONE, loot);
        SecretBlockLootTableProvider.createBlockDrop(SecretBlocks.ONE_WAY_GLASS, loot);
        SecretBlockLootTableProvider.createBlockDrop(SecretBlocks.SECRET_WOODEN_BUTTON, loot);
        SecretBlockLootTableProvider.createBlockDrop(SecretBlocks.SECRET_STONE_BUTTON, loot);
        SecretBlockLootTableProvider.createBlockDrop(SecretBlocks.TORCH_LEVER, loot);
        SecretBlockLootTableProvider.createBlockDrop(SecretBlocks.WALL_TORCH_LEVER, SecretItems.TORCH_LEVER, loot);
        SecretBlockLootTableProvider.createBlockDrop(SecretBlocks.SECRET_PRESSURE_PLATE, loot);
        SecretBlockLootTableProvider.createBlockDrop(SecretBlocks.SECRET_PLAYER_PRESSURE_PLATE, loot);
        SecretBlockLootTableProvider.createDoorItemTable(SecretBlocks.SECRET_DOOR, loot);
        SecretBlockLootTableProvider.createDoorItemTable(SecretBlocks.SECRET_IRON_DOOR, loot);
        SecretBlockLootTableProvider.createBlockDrop(SecretBlocks.SECRET_CHEST, loot);
        SecretBlockLootTableProvider.createBlockDrop(SecretBlocks.SECRET_TRAPDOOR, loot);
        SecretBlockLootTableProvider.createBlockDrop(SecretBlocks.SECRET_IRON_TRAPDOOR, loot);
        SecretBlockLootTableProvider.createBlockDrop(SecretBlocks.SECRET_TRAPPED_CHEST, loot);
        SecretBlockLootTableProvider.createBlockDrop(SecretBlocks.SECRET_GATE, loot);
        SecretBlockLootTableProvider.createBlockDrop(SecretBlocks.SECRET_DAYLIGHT_DETECTOR, loot);
        SecretBlockLootTableProvider.createBlockDrop(SecretBlocks.SECRET_OBSERVER, loot);
        SecretBlockLootTableProvider.createBlockDrop(SecretBlocks.SECRET_CLAMBER, loot);
        loot.forEach((location, table) -> {
            Path path = folder.resolve("data/" + location.func_110624_b() + "/loot_tables/" + location.func_110623_a() + ".json");
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)directoryCache, (JsonElement)LootTableManager.func_215301_a((LootTable)table), (Path)path);
            }
            catch (IOException var6) {
                SecretRooms6.LOGGER.error("Couldn't save loot table {}", (Object)path, (Object)var6);
            }
        });
    }

    public String func_200397_b() {
        return "SecretRoomsBlockLootTable";
    }

    private static void createBlockDrop(Supplier<Block> block, Map<ResourceLocation, LootTable> loot) {
        SecretBlockLootTableProvider.createBlockDrop(block, block, loot);
    }

    private static void createBlockDrop(Supplier<Block> block, Supplier<? extends IItemProvider> item, Map<ResourceLocation, LootTable> loot) {
        loot.put(block.get().func_220068_i(), SecretBlockLootTableProvider.createSingleItemTable(item.get()));
    }

    private static LootTable createSingleItemTable(IItemProvider item) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item)).func_212840_b_(SurvivesExplosion.func_215968_b())).func_216038_b();
    }

    private static void createDoorItemTable(Supplier<Block> block, Map<ResourceLocation, LootTable> loot) {
        loot.put(block.get().func_220068_i(), BlockLootTables.func_239829_a_((Block)block.get()).func_216038_b());
    }
}

