/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.server.blocks.states;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import com.wynprice.secretrooms.server.blocks.SecretBaseBlock;
import java.util.Optional;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;

public class SecretBaseState
extends BlockState {
    public SecretBaseState(Block block, ImmutableMap<Property<?>, Comparable<?>> propertiesToValueMap, MapCodec<BlockState> codec) {
        super(block, propertiesToValueMap, codec);
    }

    public boolean func_200132_m() {
        Boolean value;
        Block block = this.func_177230_c();
        if (block instanceof SecretBaseBlock && (value = ((SecretBaseBlock)block).getSolidValue()) != null) {
            return value;
        }
        return (Boolean)this.func_177229_b((Property)SecretBaseBlock.SOLID);
    }

    public float func_185887_b(IBlockReader worldIn, BlockPos pos) {
        float value = SecretBaseBlock.getValue(worldIn, pos, AbstractBlock.AbstractBlockState::func_185887_b, () -> Float.valueOf(super.func_185887_b(worldIn, pos))).floatValue();
        if (value > 5.0f) {
            return 5.0f;
        }
        if (value < 0.0f) {
            return 0.5f;
        }
        return value;
    }

    public VoxelShape func_215702_a(IBlockReader worldIn, BlockPos p, Direction directionIn) {
        return SecretBaseBlock.getValue(worldIn, p, (mirror, reader, pos1) -> mirror.func_215702_a(reader, p, directionIn), () -> super.func_215702_a(worldIn, p, directionIn));
    }

    public boolean func_224755_d(IBlockReader blockReaderIn, BlockPos blockPosIn, Direction directionIn) {
        BlockState state = blockReaderIn.func_180495_p(blockPosIn.func_177972_a(directionIn));
        Optional<BlockState> mirrorOptional = SecretBaseBlock.getMirrorState(blockReaderIn, blockPosIn);
        if (mirrorOptional.isPresent()) {
            BlockState mirror = mirrorOptional.get();
            if (Block.func_220073_a((Block)mirror.func_177230_c())) {
                return false;
            }
            if (state.func_177230_c() instanceof FenceBlock) {
                if (mirror.func_235714_a_((ITag)BlockTags.field_219748_G) && state.func_235714_a_((ITag)BlockTags.field_219756_j) == mirror.func_235714_a_((ITag)BlockTags.field_219748_G)) {
                    return true;
                }
                if (mirror.func_177230_c() instanceof FenceGateBlock && FenceGateBlock.func_220253_a((BlockState)mirror, (Direction)directionIn)) {
                    return true;
                }
            }
            if (state.func_177230_c() instanceof PaneBlock && (mirror.func_177230_c() instanceof PaneBlock || mirror.func_235714_a_((ITag)BlockTags.field_219757_z))) {
                return true;
            }
            if (state.func_177230_c() instanceof WallBlock) {
                if (mirror.func_177230_c() instanceof FenceGateBlock && FenceGateBlock.func_220253_a((BlockState)mirror, (Direction)directionIn)) {
                    return true;
                }
                if (mirror.func_177230_c() instanceof PaneBlock) {
                    return true;
                }
            }
            return mirror.func_224755_d(blockReaderIn, blockPosIn, directionIn);
        }
        return super.func_224755_d(blockReaderIn, blockPosIn, directionIn);
    }
}

