/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.server.blocks;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.TorchBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class TorchLever
extends TorchBlock {
    private static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    protected TorchLever(AbstractBlock.Properties properties) {
        super(properties, (IParticleData)ParticleTypes.field_197631_x);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        state = (BlockState)state.func_235896_a_((Property)POWERED);
        boolean isPowered = (Boolean)state.func_177229_b((Property)POWERED);
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        world.func_180501_a(pos, state, 3);
        float pitch = isPowered ? 0.6f : 0.5f;
        world.func_184133_a(null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, pitch);
        this.updateNeighbors(world, pos);
        return ActionResultType.SUCCESS;
    }

    private void updateNeighbors(World world, BlockPos pos) {
        world.func_195593_d(pos, (Block)this);
        for (Direction direction : Direction.values()) {
            world.func_195593_d(pos.func_177972_a(direction), (Block)this);
        }
    }

    public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction direction) {
        return (Boolean)state.func_177229_b((Property)POWERED) != false ? 15 : 0;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.func_177229_b((Property)POWERED) != false && side == Direction.UP ? 15 : 0;
    }

    public boolean func_149744_f(BlockState p_149744_1_) {
        return true;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            if (((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
                this.updateNeighbors(world, pos);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{POWERED});
    }
}

