/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.server.blocks;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import com.wynprice.secretrooms.client.SecretModelData;
import com.wynprice.secretrooms.server.blocks.SecretBaseBlock;
import com.wynprice.secretrooms.server.blocks.SecretBlocks;
import com.wynprice.secretrooms.server.blocks.states.SecretMappedModelState;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LadderBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.ModelDataMap;

public class SecretTrapdoor
extends SecretBaseBlock {
    private static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    private static final EnumProperty<Half> HALF = BlockStateProperties.field_208164_Q;
    private static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.field_208157_J;
    private static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    private static final VoxelShape EAST_OPEN_AABB = Block.func_208617_a((double)0.00101, (double)0.001, (double)0.001, (double)3.0, (double)15.999, (double)15.999);
    private static final VoxelShape WEST_OPEN_AABB = Block.func_208617_a((double)13.0, (double)0.001, (double)0.001, (double)15.999, (double)15.999, (double)15.999);
    private static final VoxelShape SOUTH_OPEN_AABB = Block.func_208617_a((double)0.001, (double)0.001, (double)0.001, (double)15.999, (double)15.999, (double)3.0);
    private static final VoxelShape NORTH_OPEN_AABB = Block.func_208617_a((double)0.001, (double)0.001, (double)13.0, (double)15.999, (double)15.999, (double)15.999);
    private static final VoxelShape BOTTOM_AABB = Block.func_208617_a((double)0.001, (double)0.001, (double)0.001, (double)15.999, (double)3.0, (double)15.999);
    private static final VoxelShape TOP_AABB = Block.func_208617_a((double)0.001, (double)13.0, (double)0.001, (double)15.999, (double)15.999, (double)15.999);

    public SecretTrapdoor(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a(HALF, (Comparable)Half.BOTTOM)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected BlockState createNewState(Block block, ImmutableMap<Property<?>, Comparable<?>> propertiesToValueMap, MapCodec<BlockState> codec) {
        return new SecretMappedModelState(block, propertiesToValueMap, codec);
    }

    @Override
    public void applyExtraModelData(IBlockReader world, BlockPos pos, BlockState state, ModelDataMap.Builder builder) {
        builder.withInitial(SecretModelData.MODEL_MAP_STATE, ((BlockState)((BlockState)Blocks.field_196636_cW.func_176223_P().func_206870_a((Property)HORIZONTAL_FACING, state.func_177229_b((Property)HORIZONTAL_FACING))).func_206870_a((Property)OPEN, state.func_177229_b((Property)OPEN))).func_206870_a(HALF, state.func_177229_b(HALF)));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (!((Boolean)state.func_177229_b((Property)OPEN)).booleanValue()) {
            return state.func_177229_b(HALF) == Half.TOP ? TOP_AABB : BOTTOM_AABB;
        }
        switch ((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)) {
            default: {
                return NORTH_OPEN_AABB;
            }
            case SOUTH: {
                return SOUTH_OPEN_AABB;
            }
            case WEST: {
                return WEST_OPEN_AABB;
            }
            case EAST: 
        }
        return EAST_OPEN_AABB;
    }

    @Override
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, worldIn, pos, context);
    }

    @Override
    public VoxelShape func_199600_g(BlockState state, IBlockReader world, BlockPos pos) {
        return this.func_220053_a(state, world, pos, ISelectionContext.func_216377_a());
    }

    @Override
    public VoxelShape func_230322_a_(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return state.func_196954_c(reader, pos);
    }

    @Override
    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return this.func_220053_a(state, worldIn, pos, ISelectionContext.func_216377_a());
    }

    @Override
    public Boolean getSolidValue() {
        return false;
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    @Override
    public int func_200011_d(BlockState state, IBlockReader world, BlockPos pos) {
        return 0;
    }

    @Override
    public boolean func_200123_i(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: 
            case AIR: {
                return (Boolean)state.func_177229_b((Property)OPEN);
            }
        }
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (this.field_149764_J == SecretBlocks.Materials.SRM_MATERIAL_IRON) {
            return ActionResultType.PASS;
        }
        state = (BlockState)state.func_235896_a_((Property)OPEN);
        worldIn.func_180501_a(pos, state, 2);
        SecretTrapdoor.requestModelRefresh((IBlockReader)worldIn, pos);
        this.playSound(player, worldIn, pos, (Boolean)state.func_177229_b((Property)OPEN));
        return ActionResultType.SUCCESS;
    }

    protected void playSound(@Nullable PlayerEntity player, World worldIn, BlockPos pos, boolean p_185731_4_) {
        if (p_185731_4_) {
            int i = this.field_149764_J == SecretBlocks.Materials.SRM_MATERIAL_IRON ? 1037 : 1007;
            worldIn.func_217378_a(player, i, pos, 0);
        } else {
            int j = this.field_149764_J == SecretBlocks.Materials.SRM_MATERIAL_IRON ? 1036 : 1013;
            worldIn.func_217378_a(player, j, pos, 0);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!worldIn.field_72995_K && (flag = worldIn.func_175640_z(pos)) != (Boolean)state.func_177229_b((Property)POWERED)) {
            if ((Boolean)state.func_177229_b((Property)OPEN) != flag) {
                state = (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(flag));
                this.playSound(null, worldIn, pos, flag);
            }
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 2);
            SecretTrapdoor.requestModelRefresh((IBlockReader)worldIn, pos);
            if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                worldIn.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
            }
        }
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return stateIn;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = this.func_176223_P();
        Direction direction = context.func_196000_l();
        blockstate = !context.func_196012_c() && direction.func_176740_k().func_176722_c() ? (BlockState)((BlockState)blockstate.func_206870_a((Property)HORIZONTAL_FACING, (Comparable)direction)).func_206870_a(HALF, (Comparable)(context.func_221532_j().field_72448_b - (double)context.func_195995_a().func_177956_o() > 0.5 ? Half.TOP : Half.BOTTOM)) : (BlockState)((BlockState)blockstate.func_206870_a((Property)HORIZONTAL_FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a(HALF, (Comparable)(direction == Direction.UP ? Half.BOTTOM : Half.TOP));
        if (context.func_195991_k().func_175640_z(context.func_195995_a())) {
            blockstate = (BlockState)((BlockState)blockstate.func_206870_a((Property)OPEN, (Comparable)Boolean.TRUE)).func_206870_a((Property)POWERED, (Comparable)Boolean.TRUE);
        }
        return blockstate;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{HORIZONTAL_FACING, OPEN, HALF, POWERED});
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        BlockState down;
        if (((Boolean)state.func_177229_b((Property)OPEN)).booleanValue() && (down = world.func_180495_p(pos.func_177977_b())).func_177230_c() == Blocks.field_150468_ap) {
            return down.func_177229_b((Property)LadderBlock.field_176382_a) == state.func_177229_b((Property)HORIZONTAL_FACING);
        }
        return false;
    }

    public boolean canEntitySpawn(BlockState state, IBlockReader worldIn, BlockPos pos, EntityType<?> type) {
        return false;
    }
}

