/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.server.blocks;

import com.wynprice.secretrooms.server.blocks.SecretBaseBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.StairsBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class SecretStairs
extends SecretBaseBlock {
    public static final DirectionProperty FACING = StairsBlockAccess.field_176309_a;
    public static final EnumProperty<Half> HALF = StairsBlockAccess.field_176308_b;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.field_208146_au;
    protected static final VoxelShape[] SLAB_TOP_SHAPES = StairsBlockAccess.SLAB_TOP_SHAPES;
    protected static final VoxelShape[] SLAB_BOTTOM_SHAPES = StairsBlockAccess.SLAB_BOTTOM_SHAPES;
    private static final int[] idsToShape = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    public SecretStairs(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    @Override
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (state.func_177229_b(HALF) == Half.TOP ? SLAB_TOP_SHAPES : SLAB_BOTTOM_SHAPES)[idsToShape[this.stateToId(state)]];
    }

    private int stateToId(BlockState state) {
        return ((StairsShape)state.func_177229_b(SHAPE)).ordinal() * 4 + ((Direction)state.func_177229_b((Property)FACING)).func_176736_b();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        BlockPos pos = context.func_195995_a();
        BlockState state = (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f())).func_206870_a(HALF, (Comparable)(direction != Direction.DOWN && (direction == Direction.UP || context.func_221532_j().field_72448_b - (double)pos.func_177956_o() <= 0.5) ? Half.BOTTOM : Half.TOP));
        return (BlockState)state.func_206870_a(SHAPE, (Comparable)SecretStairs.getShapeProperty(state, (IBlockReader)context.func_195991_k(), pos));
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction direction, BlockState fromState, IWorld world, BlockPos pos, BlockPos posFrom) {
        return direction.func_176740_k().func_176722_c() ? (BlockState)state.func_206870_a(SHAPE, (Comparable)SecretStairs.getShapeProperty(state, (IBlockReader)world, pos)) : super.func_196271_a(state, direction, fromState, world, pos, posFrom);
    }

    private static StairsShape getShapeProperty(BlockState state, IBlockReader world, BlockPos position) {
        Direction othersideDirection;
        Direction oppositeDirection;
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        BlockState oppositeState = world.func_180495_p(position.func_177972_a(direction));
        if (SecretStairs.isBlockStairs(oppositeState) && state.func_177229_b(HALF) == oppositeState.func_177229_b(HALF) && (oppositeDirection = (Direction)oppositeState.func_177229_b((Property)FACING)).func_176740_k() != ((Direction)state.func_177229_b((Property)FACING)).func_176740_k() && SecretStairs.isDifferentStairs(state, world, position, oppositeDirection.func_176734_d())) {
            if (oppositeDirection == direction.func_176735_f()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState othersideState = world.func_180495_p(position.func_177972_a(direction.func_176734_d()));
        if (SecretStairs.isBlockStairs(othersideState) && state.func_177229_b(HALF) == othersideState.func_177229_b(HALF) && (othersideDirection = (Direction)othersideState.func_177229_b((Property)FACING)).func_176740_k() != ((Direction)state.func_177229_b((Property)FACING)).func_176740_k() && SecretStairs.isDifferentStairs(state, world, position, othersideDirection)) {
            if (othersideDirection == direction.func_176735_f()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean isDifferentStairs(BlockState state, IBlockReader world, BlockPos pos, Direction direction) {
        BlockState offsetState = world.func_180495_p(pos.func_177972_a(direction));
        return !SecretStairs.isBlockStairs(offsetState) || offsetState.func_177229_b((Property)FACING) != state.func_177229_b((Property)FACING) || offsetState.func_177229_b(HALF) != state.func_177229_b(HALF);
    }

    public static boolean isBlockStairs(BlockState state) {
        return state.func_177230_c() instanceof StairsBlock || state.func_177230_c() instanceof SecretStairs;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING, HALF, SHAPE});
    }

    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return false;
    }

    private static class StairsBlockAccess
    extends StairsBlock {
        protected static final VoxelShape[] SLAB_TOP_SHAPES = StairsBlock.field_196520_I;
        protected static final VoxelShape[] SLAB_BOTTOM_SHAPES = StairsBlock.field_196521_J;

        protected StairsBlockAccess(BlockState p_i48321_1_, AbstractBlock.Properties p_i48321_2_) {
            super(p_i48321_1_, p_i48321_2_);
        }
    }
}

