/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.server.blocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.wynprice.secretrooms.server.blocks.SecretBaseBlock;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class SecretRedstone
extends SecretBaseBlock {
    private static final IntegerProperty POWER = BlockStateProperties.field_208136_ak;
    private boolean blockedPower = false;
    private final Set<BlockPos> toUpdate = Sets.newHashSet();

    public SecretRedstone(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{POWER});
    }

    private BlockState updateSurroundingRedstone(World worldIn, BlockPos pos, BlockState state) {
        state = this.updateNeighbourRedone(worldIn, pos, state);
        ArrayList list = Lists.newArrayList(this.toUpdate);
        this.toUpdate.clear();
        for (BlockPos blockpos : list) {
            worldIn.func_195593_d(blockpos, (Block)this);
        }
        return state;
    }

    private BlockState updateNeighbourRedone(World world, BlockPos pos, BlockState state) {
        int stateMaxPower;
        BlockState blockstate = state;
        int power = (Integer)state.func_177229_b((Property)POWER);
        this.blockedPower = true;
        int neighborPower = world.func_175687_A(pos);
        this.blockedPower = false;
        int maxPower = 0;
        if (neighborPower < 15) {
            for (Direction direction : Direction.values()) {
                maxPower = this.maxSignal(maxPower, world.func_180495_p(pos.func_177972_a(direction)));
            }
        }
        if (neighborPower > (stateMaxPower = maxPower - 1)) {
            stateMaxPower = neighborPower;
        }
        if (power != stateMaxPower) {
            state = (BlockState)state.func_206870_a((Property)POWER, (Comparable)Integer.valueOf(stateMaxPower));
            if (world.func_180495_p(pos) == blockstate) {
                world.func_180501_a(pos, state, 2);
            }
            this.toUpdate.add(pos);
            for (Direction direction : Direction.values()) {
                this.toUpdate.add(pos.func_177972_a(direction));
            }
        }
        return state;
    }

    private void notifyWireNeighborsOfStateChange(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            worldIn.func_195593_d(pos, (Block)this);
            for (Direction direction : Direction.values()) {
                worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
            }
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != state.func_177230_c() && !worldIn.field_72995_K) {
            this.updateSurroundingRedstone(worldIn, pos, state);
            for (Direction direction : Direction.Plane.VERTICAL) {
                worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
            }
            for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                this.notifyWireNeighborsOfStateChange(worldIn, pos.func_177972_a(direction1));
            }
            for (Direction direction2 : Direction.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.func_177972_a(direction2);
                if (worldIn.func_180495_p(blockpos).func_215686_e((IBlockReader)worldIn, blockpos)) {
                    this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177984_a());
                    continue;
                }
                this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177977_b());
            }
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(state, worldIn, pos, newState, false);
            if (!worldIn.field_72995_K) {
                for (Direction direction : Direction.values()) {
                    worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
                }
                this.updateSurroundingRedstone(worldIn, pos, state);
                for (Direction direction : Direction.values()) {
                    this.notifyWireNeighborsOfStateChange(worldIn, pos.func_177972_a(direction));
                }
            }
        }
    }

    private int maxSignal(int existingSignal, BlockState neighbor) {
        if (neighbor.func_177230_c() != this && neighbor.func_177230_c() != Blocks.field_150488_af) {
            return existingSignal;
        }
        int i = (Integer)neighbor.func_177229_b((Property)POWER);
        return i > existingSignal ? i : existingSignal;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K) {
            if (state.func_196955_c((IWorldReader)worldIn, pos)) {
                this.updateSurroundingRedstone(worldIn, pos, state);
            } else {
                SecretRedstone.func_220075_c((BlockState)state, (World)worldIn, (BlockPos)pos);
                worldIn.func_217377_a(pos, false);
            }
        }
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (this.blockedPower) {
            return 0;
        }
        return (Integer)blockState.func_177229_b((Property)POWER);
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return false;
    }

    public boolean func_149744_f(BlockState state) {
        return !this.blockedPower;
    }
}

