/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.server.blocks;

import com.wynprice.secretrooms.server.blocks.SecretBaseBlock;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ObserverBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SecretObserver
extends SecretBaseBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;

    public SecretObserver(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.SOUTH)).func_206870_a((Property)POWERED, (Comparable)Boolean.FALSE));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING, POWERED});
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
        } else {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 2);
        }
        this.updateNeighborsInFront((World)worldIn, pos, state);
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (stateIn.func_177229_b((Property)FACING) == facing && !((Boolean)stateIn.func_177229_b((Property)POWERED)).booleanValue()) {
            this.startSignal(worldIn, currentPos);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private void startSignal(IWorld worldIn, BlockPos pos) {
        if (!worldIn.func_201670_d() && !worldIn.func_205220_G_().func_205359_a(pos, (Object)this)) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 2);
        }
    }

    private void updateNeighborsInFront(World worldIn, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        worldIn.func_190524_a(blockpos, (Block)this, pos);
        worldIn.func_175695_a(blockpos, (Block)this, direction);
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return side == state.func_177229_b((Property)ObserverBlock.field_176387_N);
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.func_177229_b((Property)POWERED) != false && blockState.func_177229_b((Property)FACING) == side ? 15 : 0;
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return false;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.func_177230_c() != oldState.func_177230_c() && !worldIn.func_201670_d() && ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue() && !worldIn.func_205220_G_().func_205359_a(pos, (Object)this)) {
            BlockState blockstate = (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false));
            worldIn.func_180501_a(pos, blockstate, 18);
            this.updateNeighborsInFront(worldIn, pos, blockstate);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c() && !worldIn.field_72995_K && ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue() && worldIn.func_205220_G_().func_205359_a(pos, (Object)this)) {
            this.updateNeighborsInFront(worldIn, pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196010_d().func_176734_d().func_176734_d());
    }
}

