/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.server.blocks;

import com.wynprice.secretrooms.server.blocks.SecretBaseBlock;
import com.wynprice.secretrooms.server.blocks.SecretBlocks;
import com.wynprice.secretrooms.server.data.SecretData;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SecretGateBlock
extends SecretBaseBlock {
    private static final int MAX_LEVELS = 10;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    private static final DirectionProperty FACING = DirectionalBlock.field_176387_N;

    public SecretGateBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean newPowered;
        boolean powered = (Boolean)state.func_177229_b((Property)POWERED);
        if (powered != (newPowered = worldIn.func_175640_z(pos))) {
            if (newPowered) {
                this.tryBuildGate(worldIn, pos, state);
            } else {
                this.destroyGate(worldIn, pos, state, true);
            }
            worldIn.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(newPowered))).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(newPowered)));
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.destroyGate(worldIn, pos, state, false);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)FACING, (Comparable)context.func_196000_l());
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((Property)OPEN)).booleanValue()) {
            this.tryBuildGate((World)worldIn, pos, state);
        } else {
            this.destroyGate((World)worldIn, pos, state, true);
        }
        super.func_225534_a_(state, worldIn, pos, rand);
    }

    private void tryBuildGate(World world, BlockPos pos, BlockState gateState) {
        Optional<SecretData> data = SecretGateBlock.getMirrorData((IBlockReader)world, pos);
        Direction direction = (Direction)gateState.func_177229_b((Property)FACING);
        for (int i = 1; i <= 10; ++i) {
            BlockPos off = pos.func_177967_a(direction, i);
            BlockState state = world.func_180495_p(off);
            if (!state.func_185904_a().func_76222_j() && state.func_177230_c() != SecretBlocks.SECRET_DUMMY_BLOCK.get()) {
                if (state.func_177230_c() == this) {
                    world.func_175656_a(off, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(true)));
                    world.func_205220_G_().func_205360_a(off, (Object)this, 3);
                }
                return;
            }
            if (i == 10) {
                return;
            }
            for (Direction value : Direction.values()) {
                BlockPos offPos;
                BlockState offState;
                if (value.func_176740_k() == direction.func_176740_k() || (offState = world.func_180495_p(offPos = off.func_177972_a(value))).func_177230_c() != this) continue;
                world.func_175656_a(offPos, (BlockState)offState.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(true)));
                world.func_205220_G_().func_205360_a(offPos, (Object)this, 3);
            }
            world.func_175656_a(off, SecretBlocks.SECRET_DUMMY_BLOCK.get().func_176223_P());
            data.ifPresent(sdata -> SecretGateBlock.getMirrorData((IBlockReader)world, off).ifPresent(d -> d.setFrom((SecretData)sdata)));
            SecretGateBlock.requestModelRefresh((IBlockReader)world, off);
            world.func_175625_s(off).func_70296_d();
        }
    }

    private void destroyGate(World world, BlockPos pos, BlockState gateState, boolean recursive) {
        Direction direction = (Direction)gateState.func_177229_b((Property)FACING);
        for (int i = 1; i <= 10; ++i) {
            BlockPos off = pos.func_177967_a(direction, i);
            BlockState state = world.func_180495_p(off);
            if (state.func_177230_c() != SecretBlocks.SECRET_DUMMY_BLOCK.get()) {
                if (state.func_177230_c() == this && recursive) {
                    world.func_175656_a(off, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false)));
                    world.func_205220_G_().func_205360_a(off, (Object)this, 3);
                }
                return;
            }
            if (i == 10) {
                return;
            }
            if (recursive) {
                for (Direction value : Direction.values()) {
                    BlockPos offPos;
                    BlockState offState;
                    if (value.func_176740_k() == direction.func_176740_k() || (offState = world.func_180495_p(offPos = off.func_177972_a(value))).func_177230_c() != this) continue;
                    world.func_175656_a(offPos, (BlockState)offState.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false)));
                    world.func_205220_G_().func_205360_a(offPos, (Object)this, 3);
                }
            }
            world.func_175656_a(off, Blocks.field_150350_a.func_176223_P());
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{POWERED, OPEN, FACING});
    }
}

