/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.server.blocks;

import com.wynprice.secretrooms.server.blocks.SecretBaseBlock;
import com.wynprice.secretrooms.server.tileentity.SecretDaylightDetectorTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public class SecretDaylightDetector
extends SecretBaseBlock {
    public static final IntegerProperty POWER = BlockStateProperties.field_208136_ak;
    public static final BooleanProperty INVERTED = BlockStateProperties.field_208188_o;

    public SecretDaylightDetector(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)POWER, (Comparable)Integer.valueOf(0))).func_206870_a((Property)INVERTED, (Comparable)Boolean.valueOf(false)));
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Integer)blockState.func_177229_b((Property)POWER);
    }

    public static void updatePower(BlockState state, World world, BlockPos pos) {
        if (world.func_230315_m_().func_218272_d()) {
            int light = world.func_226658_a_(LightType.SKY, pos) - world.func_175657_ab();
            for (Direction value : Direction.values()) {
                light = Math.max(light, world.func_226658_a_(LightType.SKY, pos.func_177972_a(value)) - world.func_175657_ab());
            }
            float sunAngle = world.func_72929_e(1.0f);
            boolean flag = (Boolean)state.func_177229_b((Property)INVERTED);
            if (flag) {
                light = 15 - light;
            } else if (light > 0) {
                float f1 = sunAngle < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
                sunAngle += (f1 - sunAngle) * 0.2f;
                light = Math.round((float)light * MathHelper.func_76134_b((float)sunAngle));
            }
            light = MathHelper.func_76125_a((int)light, (int)0, (int)15);
            if ((Integer)state.func_177229_b((Property)POWER) != light) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWER, (Comparable)Integer.valueOf(light)), 3);
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player.func_175142_cm()) {
            if (worldIn.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            BlockState blockstate = (BlockState)state.func_235896_a_((Property)INVERTED);
            worldIn.func_180501_a(pos, blockstate, 4);
            SecretDaylightDetector.updatePower(blockstate, worldIn, pos);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return false;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SecretDaylightDetectorTileEntity();
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{POWER, INVERTED});
    }
}

