/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.server.blocks;

import com.wynprice.secretrooms.server.blocks.SecretBaseBlock;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SecretButton
extends SecretBaseBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    private final boolean wooden;

    public SecretButton(AbstractBlock.Properties properties, boolean wooden) {
        super(properties);
        this.wooden = wooden;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{POWERED});
    }

    public int func_149738_a(IWorldReader worldIn) {
        return this.wooden ? 30 : 20;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            return ActionResultType.SUCCESS;
        }
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.TRUE), 3);
        this.playSound(player, (IWorld)worldIn, pos, true);
        this.updateNeighbors(worldIn, pos);
        worldIn.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)worldIn));
        return ActionResultType.SUCCESS;
    }

    private void playSound(@Nullable PlayerEntity player, IWorld world, BlockPos pos, boolean turnOn) {
        SoundEvent woodenEvent = turnOn ? SoundEvents.field_187885_gS : SoundEvents.field_187883_gR;
        SoundEvent stoneEvent = turnOn ? SoundEvents.field_187839_fV : SoundEvents.field_187837_fU;
        world.func_184133_a((PlayerEntity)(turnOn ? player : null), pos, this.wooden ? woodenEvent : stoneEvent, SoundCategory.BLOCKS, 0.3f, turnOn ? 0.6f : 0.5f);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            if (((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
                this.updateNeighbors(worldIn, pos);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.func_177229_b((Property)POWERED) != false ? 15 : 0;
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return (Boolean)state.func_177229_b((Property)POWERED) == false;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            if (this.wooden) {
                this.checkPressed(state, (World)worldIn, pos);
            } else {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.FALSE), 3);
                this.updateNeighbors((World)worldIn, pos);
                this.playSound(null, (IWorld)worldIn, pos, false);
            }
        }
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.field_72995_K && this.wooden && !((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            this.checkPressed(state, worldIn, pos);
        }
    }

    private void checkPressed(BlockState state, World worldIn, BlockPos pos) {
        boolean flag1;
        List list = worldIn.func_217357_a(AbstractArrowEntity.class, state.func_196954_c((IBlockReader)worldIn, pos).func_197752_a().func_186670_a(pos));
        boolean flag = !list.isEmpty();
        if (flag != (flag1 = ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue())) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
            this.updateNeighbors(worldIn, pos);
            this.playSound(null, (IWorld)worldIn, pos, flag);
        }
        if (flag) {
            worldIn.func_205220_G_().func_205360_a(new BlockPos((Vector3i)pos), (Object)this, this.func_149738_a((IWorldReader)worldIn));
        }
    }

    private void updateNeighbors(World world, BlockPos pos) {
        world.func_195593_d(pos, (Block)this);
        for (Direction value : Direction.values()) {
            world.func_195593_d(pos.func_177972_a(value.func_176734_d()), (Block)this);
        }
    }
}

