/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.server.blocks;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import com.wynprice.secretrooms.client.world.DelegateWorld;
import com.wynprice.secretrooms.client.world.DummyIWorld;
import com.wynprice.secretrooms.server.blocks.states.SecretBaseState;
import com.wynprice.secretrooms.server.data.SecretData;
import com.wynprice.secretrooms.server.tileentity.SecretTileEntity;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.extensions.IForgeBlockState;
import net.minecraftforge.fml.DistExecutor;

public class SecretBaseBlock
extends Block
implements IWaterLoggable {
    public static final BooleanProperty SOLID = BooleanProperty.func_177716_a((String)"solid");
    private final StateContainer<Block, BlockState> stateContainerOverride;

    public SecretBaseBlock(AbstractBlock.Properties properties) {
        super(properties.func_208770_d());
        StateContainer.Builder builder = new StateContainer.Builder((Object)this);
        this.func_206840_a((StateContainer.Builder<Block, BlockState>)builder);
        this.stateContainerOverride = builder.func_235882_a_(Block::func_176223_P, this::createNewState);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)SOLID, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockState createNewState(Block block, ImmutableMap<Property<?>, Comparable<?>> propertiesToValueMap, MapCodec<BlockState> codec) {
        return new SecretBaseState(block, propertiesToValueMap, codec);
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        boolean value = SecretBaseBlock.getValue((IBlockReader)worldIn, pos, (m, reader, p) -> m.func_177230_c() instanceof IWaterLoggable && ((IWaterLoggable)m.func_177230_c()).func_204510_a(reader, pos, m, fluidStateIn.func_206886_c()), () -> false);
        if (value) {
            boolean fluid = super.func_204509_a(worldIn, pos, state, fluidStateIn);
            if (fluid) {
                SecretBaseBlock.getMirrorData((IBlockReader)worldIn, pos).ifPresent(d -> {
                    BlockState mirror = d.getBlockState();
                    if (mirror.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                        d.setBlockState((BlockState)mirror.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)));
                    }
                });
            }
            return fluid;
        }
        return false;
    }

    public Fluid func_204508_a(IWorld worldIn, BlockPos pos, BlockState state) {
        Fluid fluid = super.func_204508_a(worldIn, pos, state);
        if (fluid != Fluids.field_204541_a) {
            SecretBaseBlock.getMirrorData((IBlockReader)worldIn, pos).ifPresent(d -> {
                BlockState mirror = d.getBlockState();
                if (mirror.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                    d.setBlockState((BlockState)mirror.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
                }
            });
        }
        return fluid;
    }

    public StateContainer<Block, BlockState> func_176194_O() {
        return this.stateContainerOverride;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        SecretBaseBlock.getMirrorData((IBlockReader)worldIn, currentPos).ifPresent(data -> {
            DummyIWorld world;
            BlockState mirror = data.getBlockState();
            BlockState newState = mirror.func_196956_a(facing, (world = new DummyIWorld(worldIn)).func_180495_p(facingPos), (IWorld)world, currentPos, facingPos);
            if (newState != mirror) {
                data.setBlockState(newState);
                TileEntity tileEntity = world.func_175625_s(currentPos);
                data.setTileEntityNBT(tileEntity != null ? tileEntity.serializeNBT() : null);
            }
        });
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return SecretBaseBlock.getValue((IBlockReader)world, pos, (mirror, reader, pos1) -> mirror.getSoundType(world, pos1, entity), () -> super.getSoundType(state, world, pos, entity));
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return SecretBaseBlock.getValue(world, pos, (mirror, reader, pos1) -> mirror.getAiPathNodeType(reader, pos1, entity), () -> super.getAiPathNodeType(state, world, pos, entity));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SecretBaseBlock.getValue(worldIn, pos, (mirror, reader, pos1) -> mirror.func_215700_a(reader, pos1, context), () -> super.func_220053_a(state, worldIn, pos, context));
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SecretBaseBlock.getValue(worldIn, pos, (mirror, reader, pos1) -> mirror.func_215685_b(reader, pos1, context), () -> super.func_220071_b(state, worldIn, pos, context));
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return SecretBaseBlock.getValue(worldIn, pos, AbstractBlock.AbstractBlockState::func_196951_e, () -> super.func_196247_c(state, worldIn, pos));
    }

    public VoxelShape func_230322_a_(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return SecretBaseBlock.getValue(reader, pos, (m, w, p) -> m.func_199611_f(w, p, context), () -> super.func_230322_a_(state, reader, pos, context));
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return SecretBaseBlock.getValue(worldIn, pos, AbstractBlock.AbstractBlockState::func_235777_m_, () -> super.func_199600_g(state, worldIn, pos));
    }

    public float getSlipperiness(BlockState state, IWorldReader world, BlockPos pos, Entity entity) {
        return SecretBaseBlock.getValue((IBlockReader)world, pos, (m, w, p) -> Float.valueOf(m.getSlipperiness(world, p, entity)), () -> Float.valueOf(super.getSlipperiness(state, world, pos, entity))).floatValue();
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        Boolean isAoModel;
        Optional<BlockState> mirrorState;
        int result = SecretBaseBlock.getValue(world, pos, IForgeBlockState::getLightValue, () -> super.getLightValue(state, world, pos));
        if ("net.minecraft.client.renderer.BlockModelRenderer".equals(Thread.currentThread().getStackTrace()[3].getClassName()) && (mirrorState = SecretBaseBlock.getMirrorState(world, pos)).isPresent() && (isAoModel = (Boolean)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.func_71410_x().func_175602_ab().func_184389_a((BlockState)mirrorState.get()).func_177555_b())) != null) {
            return result == 0 && isAoModel != false ? 0 : 1;
        }
        return result;
    }

    public int func_200011_d(BlockState state, IBlockReader world, BlockPos pos) {
        return SecretBaseBlock.getValue(world, pos, AbstractBlock.AbstractBlockState::func_200016_a, () -> super.func_200011_d(state, world, pos));
    }

    public boolean func_200123_i(BlockState state, IBlockReader world, BlockPos pos) {
        return SecretBaseBlock.getValue(world, pos, AbstractBlock.AbstractBlockState::func_200131_a, () -> super.func_200123_i(state, world, pos));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SOLID, BlockStateProperties.field_208198_y});
    }

    public boolean addRunningEffects(BlockState state, World world, BlockPos pos, Entity entity) {
        BlockState blockstate;
        Optional<BlockState> mirrorState = SecretBaseBlock.getMirrorState((IBlockReader)world, pos);
        if (mirrorState.isPresent() && (blockstate = mirrorState.get()).func_185901_i() != BlockRenderType.INVISIBLE) {
            Vector3d vec3d = entity.func_213322_ci();
            world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate), entity.func_226277_ct_() + ((double)world.field_73012_v.nextFloat() - 0.5) * (double)entity.func_213311_cf(), entity.func_226278_cu_() + 0.1, entity.func_226281_cx_() + ((double)world.field_73012_v.nextFloat() - 0.5) * (double)entity.func_213311_cf(), vec3d.field_72450_a * -4.0, 1.5, vec3d.field_72449_c * -4.0);
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addHitEffects(BlockState state, World world, RayTraceResult target, ParticleManager manager) {
        BlockPos pos;
        Optional<BlockState> mirrorState;
        if (target instanceof BlockRayTraceResult && (mirrorState = SecretBaseBlock.getMirrorState((IBlockReader)world, pos = ((BlockRayTraceResult)target).func_216350_a())).isPresent()) {
            BlockState blockstate = mirrorState.get();
            Direction side = ((BlockRayTraceResult)target).func_216354_b();
            if (blockstate.func_185901_i() != BlockRenderType.INVISIBLE) {
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                AxisAlignedBB axisalignedbb = blockstate.func_196954_c((IBlockReader)world, pos).func_197752_a();
                double xPos = (double)x + world.field_73012_v.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
                double yPos = (double)y + world.field_73012_v.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
                double zPos = (double)z + world.field_73012_v.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
                switch (side) {
                    case UP: {
                        yPos = (double)y + axisalignedbb.field_72337_e + (double)0.1f;
                        break;
                    }
                    case DOWN: {
                        yPos = (double)y + axisalignedbb.field_72338_b - (double)0.1f;
                        break;
                    }
                    case NORTH: {
                        zPos = (double)z + axisalignedbb.field_72339_c - (double)0.1f;
                        break;
                    }
                    case SOUTH: {
                        zPos = (double)z + axisalignedbb.field_72334_f + (double)0.1f;
                        break;
                    }
                    case WEST: {
                        xPos = (double)x + axisalignedbb.field_72340_a - (double)0.1f;
                        break;
                    }
                    case EAST: {
                        xPos = (double)x + axisalignedbb.field_72336_d + (double)0.1f;
                    }
                }
                Minecraft.func_71410_x().field_71452_i.func_78873_a(new DiggingParticle((ClientWorld)world, xPos, yPos, zPos, 0.0, 0.0, 0.0, blockstate).func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f));
            }
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState stateIn, World world, BlockPos pos, ParticleManager manager) {
        Optional<BlockState> mirrorState = SecretBaseBlock.getMirrorState((IBlockReader)world, pos);
        if (mirrorState.isPresent()) {
            if (mirrorState.get().isAir((IBlockReader)world, pos)) {
                return false;
            }
            BlockState state = mirrorState.get();
            VoxelShape voxelshape = state.func_196954_c((IBlockReader)world, pos);
            voxelshape.func_197755_b((x1, y1, z1, x2, y2, z2) -> {
                double xDelta = Math.min(1.0, x2 - x1);
                double yDelta = Math.min(1.0, y2 - y1);
                double zDelta = Math.min(1.0, z2 - z1);
                int xAmount = Math.max(2, MathHelper.func_76143_f((double)(xDelta / 0.25)));
                int yAmount = Math.max(2, MathHelper.func_76143_f((double)(yDelta / 0.25)));
                int zAmount = Math.max(2, MathHelper.func_76143_f((double)(zDelta / 0.25)));
                for (int x = 0; x < xAmount; ++x) {
                    for (int y = 0; y < yAmount; ++y) {
                        for (int z = 0; z < zAmount; ++z) {
                            double dx = ((double)x + 0.5) / (double)xAmount;
                            double dy = ((double)y + 0.5) / (double)yAmount;
                            double dz = ((double)z + 0.5) / (double)zAmount;
                            double xPos = dx * xDelta + x1;
                            double yPos = dy * yDelta + y1;
                            double zPos = dz * zDelta + z1;
                            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new DiggingParticle((ClientWorld)world, (double)pos.func_177958_n() + xPos, (double)pos.func_177956_o() + yPos, (double)pos.func_177952_p() + zPos, dx - 0.5, dy - 0.5, dz - 0.5, state).func_174846_a(pos));
                        }
                    }
                }
            });
        }
        return true;
    }

    public boolean addLandingEffects(BlockState state1, ServerWorld worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        SecretBaseBlock.getMirrorState((IBlockReader)worldserver, pos).ifPresent(blockState -> worldserver.func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockState), entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), numberOfParticles, 0.0, 0.0, 0.0, (double)0.15f));
        return true;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SecretTileEntity();
    }

    public void applyExtraModelData(IBlockReader world, BlockPos pos, BlockState state, ModelDataMap.Builder builder) {
    }

    public Boolean getSolidValue() {
        return null;
    }

    public BlockState getPlaceState(IBlockReader wold, BlockPos placedOnPos, BlockState placedOn, BlockState fallback) {
        boolean waterlogged = placedOn.func_235901_b_((Property)BlockStateProperties.field_208198_y) && (Boolean)placedOn.func_177229_b((Property)BlockStateProperties.field_208198_y) != false;
        return (BlockState)((BlockState)fallback.func_206870_a((Property)SOLID, (Comparable)Boolean.valueOf(placedOn.func_200132_m()))).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(waterlogged));
    }

    public static <T> T getValue(IBlockReader world, BlockPos pos, StateFunction<T> function, Supplier<T> defaultValue) {
        return (T)SecretBaseBlock.getMirrorState(world, pos).map(DelegateWorld.createFunction(world, (reader, mirror) -> function.getValue((BlockState)mirror, world, pos))).orElseGet(defaultValue);
    }

    public static Optional<BlockState> getMirrorState(IBlockReader world, BlockPos pos) {
        return SecretBaseBlock.getMirrorData(world, pos).map(SecretData::getBlockState);
    }

    public static Optional<SecretData> getMirrorData(IBlockReader world, BlockPos pos) {
        if (world == null || pos == null) {
            return Optional.empty();
        }
        TileEntity te = world.func_175625_s(pos);
        return world.func_180495_p(pos).func_177230_c() instanceof SecretBaseBlock && te instanceof SecretTileEntity ? Optional.of(((SecretTileEntity)te).getData()) : Optional.empty();
    }

    public static void requestModelRefresh(IBlockReader world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            tileEntity.requestModelDataUpdate();
        }
    }

    public static interface StateFunction<T> {
        public T getValue(BlockState var1, IBlockReader var2, BlockPos var3);
    }
}

