/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.server.blocks;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import com.wynprice.secretrooms.server.blocks.SecretBaseBlock;
import com.wynprice.secretrooms.server.blocks.states.OneWayGlassState;
import com.wynprice.secretrooms.server.data.SecretBlockTags;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SixWayBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class OneWayGlass
extends SecretBaseBlock {
    private static final BooleanProperty NORTH = SixWayBlock.field_196488_a;
    private static final BooleanProperty EAST = SixWayBlock.field_196490_b;
    private static final BooleanProperty SOUTH = SixWayBlock.field_196492_c;
    private static final BooleanProperty WEST = SixWayBlock.field_196495_y;
    private static final BooleanProperty UP = SixWayBlock.field_196496_z;
    private static final BooleanProperty DOWN = SixWayBlock.field_196489_A;

    public OneWayGlass(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected BlockState createNewState(Block block, ImmutableMap<Property<?>, Comparable<?>> propertiesToValueMap, MapCodec<BlockState> codec) {
        return new OneWayGlassState(block, propertiesToValueMap, codec);
    }

    @Override
    public Boolean getSolidValue() {
        return true;
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player.func_184586_b(handIn).func_190926_b()) {
            worldIn.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)SixWayBlock.field_196491_B.get(hit.func_216354_b())), 3);
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity != null) {
                tileEntity.requestModelDataUpdate();
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    @Override
    public int func_200011_d(BlockState state, IBlockReader world, BlockPos pos) {
        return 0;
    }

    @Override
    public boolean func_200123_i(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        boolean isGlass = (Boolean)state.func_177229_b((Property)SixWayBlock.field_196491_B.get(side));
        boolean isInCullTag = adjacentBlockState.func_235714_a_(SecretBlockTags.ONE_WAY_GLASS_CULL);
        return super.func_200122_a(state, adjacentBlockState, side) || isGlass && isInCullTag;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos offFace = context.func_196012_c() ? context.func_195995_a() : context.func_195995_a().func_177972_a(context.func_196000_l().func_176734_d());
        BlockState state = context.func_195991_k().func_180495_p(offFace);
        if (state.func_177230_c() == this) {
            return state;
        }
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)SixWayBlock.field_196491_B.get(context.func_196010_d().func_176734_d()), (Comparable)Boolean.valueOf(false));
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        TileEntity tileEntity = worldIn.func_175625_s(currentPos);
        if (tileEntity != null && tileEntity.func_145831_w().field_72995_K) {
            tileEntity.requestModelDataUpdate();
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }
}

