/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.server.blocks;

import com.wynprice.secretrooms.server.blocks.SecretBaseBlock;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractSecretPressurePlateBase
extends SecretBaseBlock {
    public AbstractSecretPressurePlateBase(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Override
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return super.func_220071_b(state, worldIn, pos, context);
    }

    public int func_149738_a(IWorldReader worldIn) {
        return 20;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        int i;
        if (!worldIn.field_72995_K && (i = this.getRedstoneStrength(state)) > 0) {
            this.updateState((World)worldIn, pos, state, i);
        }
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        BlockState state = worldIn.func_180495_p(pos);
        if (!worldIn.field_72995_K) {
            int i = this.getRedstoneStrength(state);
            this.updateState(worldIn, pos, state, i);
        }
    }

    protected void updateState(World worldIn, BlockPos pos, BlockState state, int oldRedstoneStrength) {
        boolean flag1;
        int i = this.computeRedstoneStrength(worldIn, pos);
        boolean flag = oldRedstoneStrength > 0;
        boolean bl = flag1 = i > 0;
        if (oldRedstoneStrength != i) {
            BlockState blockstate = this.setRedstoneStrength(state, i);
            worldIn.func_180501_a(pos, blockstate, 2);
            this.updateNeighbors(worldIn, pos);
            worldIn.func_225319_b(pos, state, blockstate);
        }
        if (!flag1 && flag) {
            this.playClickOffSound((IWorld)worldIn, pos);
        } else if (flag1 && !flag) {
            this.playClickOnSound((IWorld)worldIn, pos);
        }
        if (flag1) {
            worldIn.func_205220_G_().func_205360_a(new BlockPos((Vector3i)pos), (Object)this, this.func_149738_a((IWorldReader)worldIn));
        }
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return this.getRedstoneStrength(blockState);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            if (this.getRedstoneStrength(state) > 0) {
                this.updateNeighbors(worldIn, pos);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    private void updateNeighbors(World worldIn, BlockPos pos) {
        worldIn.func_195593_d(pos, (Block)this);
        worldIn.func_195593_d(pos.func_177977_b(), (Block)this);
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return this.getRedstoneStrength(state) == 0;
    }

    protected abstract void playClickOnSound(IWorld var1, BlockPos var2);

    protected abstract void playClickOffSound(IWorld var1, BlockPos var2);

    protected abstract int computeRedstoneStrength(World var1, BlockPos var2);

    protected abstract int getRedstoneStrength(BlockState var1);

    protected abstract BlockState setRedstoneStrength(BlockState var1, int var2);
}

