/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.client.world;

import com.wynprice.secretrooms.server.blocks.SecretBaseBlock;
import com.wynprice.secretrooms.server.data.SecretData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.lighting.WorldLightManager;

public class DelegateWorld
implements IBlockDisplayReader {
    private static final List<DelegateWorld> AVAILABLE = new ArrayList<DelegateWorld>();
    private IBlockDisplayReader reader;
    private IBlockReader world;

    public static synchronized DelegateWorld getPooled(IBlockReader reader) {
        if (AVAILABLE.isEmpty()) {
            return new DelegateWorld(reader);
        }
        DelegateWorld world = AVAILABLE.get(0);
        world.use(reader);
        return world;
    }

    public static <T> Function<BlockState, T> createFunction(IBlockReader reader, BiFunction<DelegateWorld, BlockState, T> func) {
        return mirror -> {
            DelegateWorld pooled = DelegateWorld.getPooled(reader);
            Object ret = func.apply(pooled, (BlockState)mirror);
            pooled.release();
            return ret;
        };
    }

    public DelegateWorld(IBlockReader world) {
        this.use(world);
    }

    private void use(IBlockReader world) {
        this.world = world;
        this.reader = this.world instanceof IBlockDisplayReader ? (IBlockDisplayReader)this.world : null;
    }

    public void release() {
        AVAILABLE.add(this);
        this.world = null;
        this.reader = null;
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        return SecretBaseBlock.getMirrorData(this.world, pos).map(SecretData::getTileEntityCache).orElseGet(() -> this.world.func_175625_s(pos));
    }

    public BlockState func_180495_p(BlockPos pos) {
        return SecretBaseBlock.getMirrorState(this.world, pos).orElseGet(() -> this.world.func_180495_p(pos));
    }

    public FluidState func_204610_c(BlockPos pos) {
        return this.world.func_204610_c(pos);
    }

    public float func_230487_a_(Direction p_230487_1_, boolean p_230487_2_) {
        return 0.0f;
    }

    public WorldLightManager func_225524_e_() {
        if (this.reader != null) {
            return this.reader.func_225524_e_();
        }
        throw new IllegalStateException("Invalid Call on Delegate World, resulting in a Invalid State. WORLD: " + this.world.getClass());
    }

    public int func_225525_a_(BlockPos blockPosIn, ColorResolver colorResolverIn) {
        return this.reader == null ? 0 : this.reader.func_225525_a_(blockPosIn, colorResolverIn);
    }
}

