/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.client.model;

import com.google.common.math.DoubleMath;
import com.wynprice.secretrooms.client.SecretModelData;
import com.wynprice.secretrooms.client.model.SecretBlockModel;
import com.wynprice.secretrooms.server.utils.ModelDataUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.model.data.IModelData;

public class SecretMappedModel
extends SecretBlockModel {
    private final Map<BlockState, AxisAlignedBB> stateAreaCache = new HashMap<BlockState, AxisAlignedBB>();
    private static final Supplier<BlockRendererDispatcher> DISPATCHER = () -> Minecraft.func_71410_x().func_175602_ab();

    public SecretMappedModel(IBakedModel model) {
        super(model);
    }

    @Override
    public List<BakedQuad> render(@Nonnull BlockState mirrorState, @Nonnull BlockState baseState, @Nonnull IBakedModel model, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        Optional<BlockState> blockState = ModelDataUtils.getData(extraData, SecretModelData.MODEL_MAP_STATE);
        if (!blockState.isPresent()) {
            return super.render(mirrorState, baseState, model, side, rand, extraData);
        }
        if (side != null) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> outQuads = new ArrayList<BakedQuad>();
        BlockState mappedState = blockState.get();
        IBakedModel mappedModel = DISPATCHER.get().func_184389_a(mappedState);
        AxisAlignedBB bb = this.createQuadBorder(mappedModel, mappedState, rand, extraData);
        ArrayList allQuads = new ArrayList(model.getQuads(mirrorState, null, rand, extraData));
        for (Direction value : Direction.values()) {
            allQuads.addAll(model.getQuads(mirrorState, value, rand, extraData));
        }
        for (BakedQuad quad : allQuads) {
            outQuads.add(this.resizeQuad(quad, bb));
        }
        return outQuads;
    }

    private BakedQuad resizeQuad(BakedQuad texture, AxisAlignedBB modelRange) {
        List<Vector3d> vertices = this.getVertexPositions(texture);
        List<Vector3d> clamped = this.clampVertexPositions(modelRange, vertices);
        int size = DefaultVertexFormats.field_176600_a.func_181719_f();
        int[] aint = new int[texture.func_178209_a().length];
        System.arraycopy(texture.func_178209_a(), 0, aint, 0, aint.length);
        for (int v = 0; v < clamped.size(); ++v) {
            Vector3d vec = clamped.get(v);
            aint[v * size] = Float.floatToIntBits((float)vec.field_72450_a);
            aint[v * size + 1] = Float.floatToIntBits((float)vec.field_72448_b);
            aint[v * size + 2] = Float.floatToIntBits((float)vec.field_72449_c);
        }
        this.resetUVPositions(aint, size, 4, vertices, clamped);
        return new BakedQuad(aint, texture.func_178211_c(), texture.func_178210_d(), texture.func_187508_a(), texture.func_239287_f_());
    }

    private void resetUVPositions(int[] aint, int size, int uOff, List<Vector3d> vertices, List<Vector3d> clampedVertices) {
        boolean uvRot = aint[uOff] == aint[size + uOff];
        int[] t = new int[]{1, 0, 3, 2};
        int[] a = new int[]{3, 2, 1, 0};
        int[] mappedU = uvRot ? a : t;
        int[] mappedV = uvRot ? t : a;
        for (int v = 0; v < 4; ++v) {
            if (vertices.get(v).equals((Object)clampedVertices.get(v))) continue;
            Vector3d clamped = clampedVertices.get(v);
            Vector3d from = vertices.get(v);
            Vector3d toU = vertices.get(mappedU[v]);
            Vector3d toV = vertices.get(mappedV[v]);
            Direction.Axis uAxis = this.getDifferential(from, toU);
            Direction.Axis vAxis = this.getDifferential(from, toV);
            double uInterpolated = this.dist(clamped, from, uAxis) / this.dist(toU, from, uAxis);
            double vInterpolated = this.dist(clamped, from, vAxis) / this.dist(toV, from, vAxis);
            aint[v * size + uOff] = Float.floatToIntBits((float)this.interpolate(Float.intBitsToFloat(aint[v * size + uOff]), Float.intBitsToFloat(aint[mappedU[v] * size + uOff]), uInterpolated));
            aint[v * size + uOff + 1] = Float.floatToIntBits((float)this.interpolate(Float.intBitsToFloat(aint[v * size + uOff + 1]), Float.intBitsToFloat(aint[mappedV[v] * size + uOff + 1]), vInterpolated));
        }
    }

    private Direction.Axis getDifferential(Vector3d v1, Vector3d v2) {
        if (!DoubleMath.fuzzyEquals((double)v1.field_72450_a, (double)v2.field_72450_a, (double)1.0E-7)) {
            return Direction.Axis.X;
        }
        if (!DoubleMath.fuzzyEquals((double)v1.field_72448_b, (double)v2.field_72448_b, (double)1.0E-7)) {
            return Direction.Axis.Y;
        }
        if (!DoubleMath.fuzzyEquals((double)v1.field_72449_c, (double)v2.field_72449_c, (double)1.0E-7)) {
            return Direction.Axis.Z;
        }
        return null;
    }

    private double interpolate(double from, double to, double alpha) {
        return from + (to - from) * alpha;
    }

    private double dist(Vector3d v1, Vector3d v2, Direction.Axis axis) {
        if (axis == null) {
            return 1.0;
        }
        switch (axis) {
            case X: {
                return Math.abs(v1.field_72450_a - v2.field_72450_a);
            }
            case Y: {
                return Math.abs(v1.field_72448_b - v2.field_72448_b);
            }
            case Z: {
                return Math.abs(v1.field_72449_c - v2.field_72449_c);
            }
        }
        return 1.0;
    }

    private List<Vector3d> clampVertexPositions(AxisAlignedBB modelQuadRange, List<Vector3d> vertices) {
        ArrayList<Vector3d> out = new ArrayList<Vector3d>();
        for (Vector3d vertex : vertices) {
            out.add(new Vector3d(MathHelper.func_151237_a((double)vertex.field_72450_a, (double)modelQuadRange.field_72340_a, (double)modelQuadRange.field_72336_d), MathHelper.func_151237_a((double)vertex.field_72448_b, (double)modelQuadRange.field_72338_b, (double)modelQuadRange.field_72337_e), MathHelper.func_151237_a((double)vertex.field_72449_c, (double)modelQuadRange.field_72339_c, (double)modelQuadRange.field_72334_f)));
        }
        return out;
    }

    private List<Vector3d> getVertexPositions(BakedQuad quad) {
        int size = DefaultVertexFormats.field_176600_a.func_181719_f();
        int[] aint = quad.func_178209_a();
        ArrayList<Vector3d> out = new ArrayList<Vector3d>();
        for (int v = 0; v < 4; ++v) {
            out.add(new Vector3d((double)Float.intBitsToFloat(aint[v * size]), (double)Float.intBitsToFloat(aint[v * size + 1]), (double)Float.intBitsToFloat(aint[v * size + 2])));
        }
        return out;
    }

    private AxisAlignedBB createQuadBorder(IBakedModel mappedModel, BlockState state, Random rand, IModelData extraData) {
        if (this.stateAreaCache.containsKey(state)) {
            return this.stateAreaCache.get(state);
        }
        ArrayList modelQuads = new ArrayList(mappedModel.getQuads(state, null, rand, extraData));
        for (Direction direction : Direction.values()) {
            modelQuads.addAll(mappedModel.getQuads(state, direction, rand, extraData));
        }
        Vector3d min = new Vector3d(2.147483647E9, 2.147483647E9, 2.147483647E9);
        Vector3d max = new Vector3d(-2.147483648E9, -2.147483648E9, -2.147483648E9);
        for (BakedQuad quad : modelQuads) {
            for (Vector3d vertexPos : this.getVertexPositions(quad)) {
                this.setVec(min, vertexPos, Math::min);
                this.setVec(max, vertexPos, Math::max);
            }
        }
        AxisAlignedBB bb = new AxisAlignedBB(min.field_72450_a, min.field_72448_b, min.field_72449_c, max.field_72450_a, max.field_72448_b, max.field_72449_c);
        this.stateAreaCache.put(state, bb);
        return bb;
    }

    private void setVec(Vector3d toSet, Vector3d vertex, BiFunction<Double, Double, Double> cons) {
        toSet.field_72450_a = cons.apply(toSet.field_72450_a, vertex.field_72450_a);
        toSet.field_72448_b = cons.apply(toSet.field_72448_b, vertex.field_72448_b);
        toSet.field_72449_c = cons.apply(toSet.field_72449_c, vertex.field_72449_c);
    }
}

