/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.client.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.wynprice.secretrooms.client.SecretModelData;
import com.wynprice.secretrooms.server.utils.ModelDataUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class SecretBlockModel
implements IBakedModel {
    private static final Supplier<BlockRendererDispatcher> DISPATCHER = () -> Minecraft.func_71410_x().func_175602_ab();
    private final IBakedModel model;

    public SecretBlockModel(IBakedModel model) {
        this.model = model;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData extraData) {
        return ModelDataUtils.getData(extraData, SecretModelData.SRM_BLOCKSTATE).filter(this::canRenderInLater).map(mirrorState -> this.render((BlockState)mirrorState, state, DISPATCHER.get().func_184389_a(mirrorState), side, rand, extraData)).orElse(new ArrayList());
    }

    protected boolean canRenderInLater(BlockState state) {
        RenderType renderLayer = MinecraftForgeClient.getRenderLayer();
        return renderLayer == null || RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)renderLayer);
    }

    protected List<BakedQuad> render(@Nonnull BlockState mirrorState, @Nonnull BlockState baseState, @Nonnull IBakedModel model, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        return new ArrayList<BakedQuad>(model.getQuads(mirrorState, side, rand, extraData));
    }

    public TextureAtlasSprite getParticleTexture(IModelData data) {
        return ModelDataUtils.getData(data, SecretModelData.SRM_BLOCKSTATE).map(arg_0 -> ((BlockRendererDispatcher)DISPATCHER.get()).func_184389_a(arg_0)).orElse(this.model).getParticleTexture(data);
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        IModelData data;
        TileEntity entity;
        if (tileData == EmptyModelData.INSTANCE && (entity = world.func_175625_s(pos)) != null) {
            tileData = entity.getModelData();
        }
        if ((data = this.model.getModelData(world, pos, state, tileData)) != tileData && tileData != EmptyModelData.INSTANCE) {
            if (tileData.hasProperty(SecretModelData.SRM_BLOCKSTATE) && !data.hasProperty(SecretModelData.SRM_BLOCKSTATE)) {
                data.setData(SecretModelData.SRM_BLOCKSTATE, tileData.getData(SecretModelData.SRM_BLOCKSTATE));
            }
            if (tileData.hasProperty(SecretModelData.MODEL_MAP_STATE) && !data.hasProperty(SecretModelData.MODEL_MAP_STATE)) {
                data.setData(SecretModelData.MODEL_MAP_STATE, tileData.getData(SecretModelData.MODEL_MAP_STATE));
            }
        }
        return data;
    }

    public boolean func_177556_c() {
        return this.model.func_177556_c();
    }

    public boolean func_230044_c_() {
        return false;
    }

    public List<BakedQuad> func_200117_a(BlockState state, Direction side, Random rand) {
        return this.model.func_200117_a(state, side, rand);
    }

    public ItemCameraTransforms func_177552_f() {
        return this.model.func_177552_f();
    }

    public boolean func_177555_b() {
        return this.model.func_177555_b();
    }

    public boolean isAmbientOcclusion(BlockState state) {
        return this.model.isAmbientOcclusion(state);
    }

    public TextureAtlasSprite func_177554_e() {
        return this.model.func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return this.model.func_188617_f();
    }

    public boolean func_188618_c() {
        return false;
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
        return this.model.handlePerspective(cameraTransformType, mat);
    }
}

