/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.client.model;

import com.wynprice.secretrooms.client.model.SecretBlockModel;
import com.wynprice.secretrooms.client.model.quads.NoTintBakedQuadRetextured;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SixWayBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class OneWayGlassModel
extends SecretBlockModel {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static IBakedModel glassModel;

    public OneWayGlassModel(IBakedModel model) {
        super(model);
    }

    @Override
    protected boolean canRenderInLater(BlockState state) {
        return MinecraftForgeClient.getRenderLayer() == RenderType.func_228643_e_() || super.canRenderInLater(state);
    }

    @Override
    public List<BakedQuad> render(@Nonnull BlockState mirrorState, @Nonnull BlockState baseState, @Nonnull IBakedModel model, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        RenderType startLayer = MinecraftForgeClient.getRenderLayer();
        Supplier<List<BakedQuad>> superQuads = () -> this.getQuadsForSide(mirrorState, baseState, side, rand, extraData);
        List<BakedQuad> out = this.getQuadsNotSolid(baseState, mirrorState, superQuads, extraData);
        ForgeHooksClient.setRenderLayer((RenderType)startLayer);
        return out;
    }

    private List<BakedQuad> getQuadsNotSolid(BlockState baseState, BlockState delegate, Supplier<List<BakedQuad>> superQuads, IModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (MinecraftForgeClient.getRenderLayer() == RenderType.func_228643_e_()) {
            quads.addAll(this.getGlassQuadsNotSolid(baseState, delegate, superQuads, extraData));
            ForgeHooksClient.setRenderLayer((RenderType)RenderType.func_228643_e_());
        }
        quads.addAll(this.getDelegateQuadsNotSolid(baseState, delegate, superQuads));
        return quads;
    }

    private List<BakedQuad> getGlassQuadsNotSolid(BlockState baseState, BlockState delegate, Supplier<List<BakedQuad>> superQuads, IModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (RenderType value : RenderType.func_228661_n_()) {
            ForgeHooksClient.setRenderLayer((RenderType)value);
            if (!RenderTypeLookup.canRenderInLayer((BlockState)delegate, (RenderType)value) && MinecraftForgeClient.getRenderLayer() != RenderType.func_228643_e_()) continue;
            for (BakedQuad bakedQuad : superQuads.get()) {
                if (!((Boolean)baseState.func_177229_b((Property)SixWayBlock.field_196491_B.get(bakedQuad.func_178210_d()))).booleanValue() || MinecraftForgeClient.getRenderLayer() != RenderType.func_228643_e_()) continue;
                quads.add(new NoTintBakedQuadRetextured(bakedQuad, glassModel.getParticleTexture(extraData)));
            }
        }
        return quads;
    }

    private List<BakedQuad> getDelegateQuadsNotSolid(BlockState baseState, BlockState delegate, Supplier<List<BakedQuad>> superQuads) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (BakedQuad bakedQuad : superQuads.get()) {
            if (((Boolean)baseState.func_177229_b((Property)SixWayBlock.field_196491_B.get(bakedQuad.func_178210_d()))).booleanValue()) continue;
            quads.add(bakedQuad);
        }
        return quads;
    }

    private List<BakedQuad> getQuadsForSide(BlockState mirrorState, BlockState baseState, Direction side, Random rand, IModelData extraData) {
        List<BakedQuad> quads = super.render(mirrorState, baseState, MC.func_175602_ab().func_184389_a(mirrorState), side, rand, extraData);
        super.render(mirrorState, baseState, MC.func_175602_ab().func_184389_a(mirrorState), null, rand, extraData).stream().filter(q -> q.func_178210_d() == side).forEach(quads::add);
        return quads;
    }

    @SubscribeEvent
    public static void onModelsReady(ModelBakeEvent event) {
        glassModel = event.getModelManager().func_174953_a(BlockModelShapes.func_209554_c((BlockState)Blocks.field_150359_w.func_176223_P()));
    }
}

