/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms;

import com.wynprice.secretrooms.client.SecretModelHandler;
import com.wynprice.secretrooms.client.SwitchProbeTooltipRenderer;
import com.wynprice.secretrooms.client.model.OneWayGlassModel;
import com.wynprice.secretrooms.server.blocks.SecretBaseBlock;
import com.wynprice.secretrooms.server.blocks.SecretBlocks;
import com.wynprice.secretrooms.server.data.SecretBlockLootTableProvider;
import com.wynprice.secretrooms.server.data.SecretBlockTagsProvider;
import com.wynprice.secretrooms.server.data.SecretItemTagsProvider;
import com.wynprice.secretrooms.server.data.SecretRecipeProvider;
import com.wynprice.secretrooms.server.items.SecretItems;
import com.wynprice.secretrooms.server.tileentity.SecretTileEntities;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="secretroomsmod")
public class SecretRooms6 {
    public static final String MODID = "secretroomsmod";
    public static final Logger LOGGER = LogManager.getLogger((String)"secretroomsmod");
    public static final ItemGroup TAB = new ItemGroup(-1, "secretroomsmod"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)SecretItems.CAMOUFLAGE_PASTE.get());
        }
    };

    public SecretRooms6() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        bus.addListener(this::gatherData);
        SecretBlocks.REGISTRY.register(bus);
        SecretItems.REGISTRY.register(bus);
        SecretTileEntities.REGISTRY.register(bus);
        forgeBus.addListener(this::modifyBreakSpeed);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            bus.addListener(SecretModelHandler::onBlockColors);
            bus.addListener(SecretModelHandler::onModelBaked);
            bus.addListener(OneWayGlassModel::onModelsReady);
            bus.addListener(this::clientSetup);
            forgeBus.addListener(SwitchProbeTooltipRenderer::onTooltip);
        });
    }

    public void modifyBreakSpeed(PlayerEvent.BreakSpeed event) {
        PlayerEntity player = event.getPlayer();
        SecretBaseBlock.getMirrorState((IBlockReader)player.field_70170_p, event.getPos()).ifPresent(mirror -> {
            float f = player.field_71071_by.func_184438_a(mirror);
            if (f > 1.0f) {
                int i = EnchantmentHelper.func_185293_e((LivingEntity)player);
                ItemStack itemstack = player.func_184614_ca();
                if (i > 0 && !itemstack.func_190926_b()) {
                    f += (float)(i * i + 1);
                }
            }
            if (EffectUtils.func_205135_a((LivingEntity)player)) {
                f *= 1.0f + (float)(EffectUtils.func_205134_b((LivingEntity)player) + 1) * 0.2f;
            }
            if (player.func_70644_a(Effects.field_76419_f)) {
                float f1;
                switch (player.func_70660_b(Effects.field_76419_f).func_76458_c()) {
                    case 0: {
                        f1 = 0.3f;
                        break;
                    }
                    case 1: {
                        f1 = 0.09f;
                        break;
                    }
                    case 2: {
                        f1 = 0.0027f;
                        break;
                    }
                    default: {
                        f1 = 8.1E-4f;
                    }
                }
                f *= f1;
            }
            if (player.func_208600_a((ITag)FluidTags.field_206959_a) && !EnchantmentHelper.func_185287_i((LivingEntity)player)) {
                f /= 5.0f;
            }
            if (!player.func_233570_aj_()) {
                f /= 5.0f;
            }
            event.setNewSpeed(f);
        });
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            gen.func_200390_a((IDataProvider)new SecretRecipeProvider(gen));
            gen.func_200390_a((IDataProvider)new SecretItemTagsProvider(gen, helper));
            gen.func_200390_a((IDataProvider)new SecretBlockTagsProvider(gen, helper));
            gen.func_200390_a((IDataProvider)new SecretBlockLootTableProvider(gen));
        }
    }

    public void clientSetup(FMLClientSetupEvent clientSetupEvent) {
        for (Block block : new Block[]{SecretBlocks.GHOST_BLOCK.get(), SecretBlocks.SECRET_STAIRS.get(), SecretBlocks.SECRET_LEVER.get(), SecretBlocks.SECRET_REDSTONE.get(), SecretBlocks.ONE_WAY_GLASS.get(), SecretBlocks.SECRET_WOODEN_BUTTON.get(), SecretBlocks.SECRET_STONE_BUTTON.get(), SecretBlocks.SECRET_PRESSURE_PLATE.get(), SecretBlocks.SECRET_PLAYER_PRESSURE_PLATE.get(), SecretBlocks.SECRET_DOOR.get(), SecretBlocks.SECRET_IRON_DOOR.get(), SecretBlocks.SECRET_CHEST.get(), SecretBlocks.SECRET_TRAPDOOR.get(), SecretBlocks.SECRET_IRON_TRAPDOOR.get(), SecretBlocks.SECRET_TRAPPED_CHEST.get(), SecretBlocks.SECRET_GATE.get(), SecretBlocks.SECRET_DUMMY_BLOCK.get(), SecretBlocks.SECRET_DAYLIGHT_DETECTOR.get(), SecretBlocks.SECRET_OBSERVER.get(), SecretBlocks.SECRET_CLAMBER.get()}) {
            RenderTypeLookup.setRenderLayer((Block)block, type -> true);
        }
        RenderTypeLookup.setRenderLayer((Block)SecretBlocks.TORCH_LEVER.get(), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)SecretBlocks.WALL_TORCH_LEVER.get(), (RenderType)RenderType.func_228643_e_());
    }
}

