/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import wile.rsgauges.blocks.ContactSwitchBlock;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.detail.SwitchLink;

public class TrapdoorSwitchBlock
extends ContactSwitchBlock {
    public TrapdoorSwitchBlock(long config, AbstractBlock.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: 
            case AIR: {
                return (Boolean)state.func_177229_b((Property)POWERED) == false;
            }
        }
        return true;
    }

    @Override
    public void func_180658_a(World world, BlockPos pos, Entity entity, float distance) {
        if ((this.config & 0x400000000000L) != 0L) {
            BlockPos[] neighbors;
            if (world.func_201670_d()) {
                return;
            }
            this.onEntityCollided(world, pos, world.func_180495_p(pos));
            for (BlockPos p : neighbors = new BlockPos[]{pos.func_177982_a(1, 0, 0), pos.func_177982_a(-1, 0, 0), pos.func_177982_a(0, 0, 1), pos.func_177982_a(0, 0, -1), pos.func_177982_a(1, 0, 1), pos.func_177982_a(-1, 0, -1), pos.func_177982_a(-1, 0, 1), pos.func_177982_a(1, 0, -1)}) {
                BlockState st = world.func_180495_p(p);
                if (st == null || st.func_177230_c() != this) continue;
                this.onEntityCollided(world, p, st);
            }
        }
        super.func_180658_a(world, pos, entity, distance);
    }

    @Override
    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        BlockPos[] neighbors;
        if ((this.config & 0x800000000000L) == 0L || world.func_201670_d() || entity.func_225608_bj_()) {
            return;
        }
        this.onEntityCollided(world, pos, world.func_180495_p(pos));
        for (BlockPos p : neighbors = new BlockPos[]{pos.func_177982_a(1, 0, 0), pos.func_177982_a(-1, 0, 0), pos.func_177982_a(0, 0, 1), pos.func_177982_a(0, 0, -1), pos.func_177982_a(1, 0, 1), pos.func_177982_a(-1, 0, -1), pos.func_177982_a(-1, 0, 1), pos.func_177982_a(1, 0, -1)}) {
            BlockState st = world.func_180495_p(p);
            if (st == null || st.func_177230_c() != this) continue;
            this.onEntityCollided(world, p, st);
        }
    }

    @Override
    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if ((this.config & 0x400000000000L) != 0L && (double)entity.func_213302_cg() < 0.9) {
            return;
        }
        this.onEntityCollided(world, pos, state);
    }

    @Override
    protected AxisAlignedBB detectionVolume(BlockPos pos) {
        if ((this.config & 0xC00000000000L) == 0L) {
            return new AxisAlignedBB(Vector3d.func_237491_b_((Vector3i)pos).func_72441_c(0.0, 0.0, 0.0), Vector3d.func_237491_b_((Vector3i)pos).func_72441_c(1.0, 1.0, 1.0));
        }
        return new AxisAlignedBB(Vector3d.func_237491_b_((Vector3i)pos).func_72441_c(-0.2, 0.0, -0.2), Vector3d.func_237491_b_((Vector3i)pos).func_72441_c(1.2, 2.0, 1.2));
    }

    @Override
    public SwitchLink.RequestResult switchLinkTrigger(SwitchLink link) {
        World world = link.world;
        BlockPos pos = link.target_position;
        if (world == null || (this.config & 0x200000000000000L) == 0L || world.func_201670_d()) {
            return SwitchLink.RequestResult.REJECTED;
        }
        BlockState state = world.func_180495_p(pos);
        if (state == null || !(state.func_177230_c() instanceof TrapdoorSwitchBlock)) {
            return SwitchLink.RequestResult.REJECTED;
        }
        if (((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            return SwitchLink.RequestResult.OK;
        }
        ContactSwitchBlock.ContactSwitchTileEntity te = this.getTe((IWorldReader)world, pos);
        if (te == null || !te.verifySwitchLinkTarget(link)) {
            return SwitchLink.RequestResult.REJECTED;
        }
        world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true)), 27);
        this.power_on_sound.play(world, pos);
        this.notifyNeighbours(world, pos, state, te, false);
        te.on_timer_reset(te.configured_on_time() == 0 ? 20 : Math.max(te.configured_on_time(), 2));
        te.reschedule_block_tick();
        return SwitchLink.RequestResult.OK;
    }
}

