/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.Optional;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.rsgauges.blocks.RsBlock;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.ColorUtils;

public class SensitiveGlassBlock
extends RsBlock {
    public static final BooleanProperty POWERED = BooleanProperty.func_177716_a((String)"powered");
    public static final ColorUtils.DyeColorProperty COLOR = ColorUtils.DyeColorProperty.create("color");

    public SensitiveGlassBlock(AbstractBlock.Properties properties) {
        super(0x3000000000000000L, properties, Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0));
        this.func_180632_j((BlockState)((BlockState)super.func_176223_P().func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)COLOR, (Comparable)DyeColor.WHITE));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader world, BlockPos pos) {
        return 0.95f;
    }

    @Override
    public RsBlock.RenderTypeHint getRenderTypeHint() {
        return RsBlock.RenderTypeHint.TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        if (!(adjacentBlockState.func_177230_c() instanceof SensitiveGlassBlock)) {
            return false;
        }
        return adjacentBlockState.func_177229_b((Property)POWERED) == state.func_177229_b((Property)POWERED);
    }

    @Override
    public boolean func_181623_g() {
        return false;
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return true;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{POWERED, COLOR});
    }

    @Override
    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (world.func_201670_d()) {
            return;
        }
        if (((Boolean)state.func_177229_b((Property)POWERED)).booleanValue() && !world.func_175640_z(pos)) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)), 27);
        }
    }

    @Override
    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        return state == null ? null : (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(context.func_195991_k().func_175640_z(context.func_195995_a())));
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        Optional<DyeColor> dye = ColorUtils.getColorFromDyeItem(stack);
        if (!dye.isPresent()) {
            return ActionResultType.PASS;
        }
        world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)COLOR, (Comparable)dye.get()), 3);
        return world.func_201670_d() ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
    }

    @Override
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean powered;
        if (world.func_201670_d()) {
            return;
        }
        boolean was_powered = (Boolean)state.func_177229_b((Property)POWERED);
        if (was_powered == (powered = world.func_175640_z(pos))) {
            return;
        }
        if (powered) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        } else {
            world.func_205220_G_().func_205360_a(pos, (Object)this, 4);
        }
    }
}

