/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.detail;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import wile.rsgauges.ModConfig;
import wile.rsgauges.ModContent;

public class SwitchLink {
    public final BlockPos target_position;
    public final String block_name;
    public final boolean valid;
    private long config;
    public int source_analog_power = 0;
    public int source_digital_power = 0;
    public BlockPos source_position = BlockPos.field_177992_a;
    @Nullable
    public World world;
    @Nullable
    public PlayerEntity player;

    public SwitchLink() {
        this.target_position = BlockPos.field_177992_a;
        this.block_name = "";
        this.config = 0L;
        this.valid = false;
    }

    public SwitchLink(BlockPos pos, String name, long cfg) {
        this.target_position = pos;
        this.block_name = name;
        this.config = cfg;
        this.valid = !this.block_name.isEmpty() && pos.func_218275_a() != 0L;
    }

    public String toString() {
        return "SwitchLink{pos=" + this.target_position.toString() + ", block='" + this.block_name + "', config=" + Long.toString(this.config) + "}";
    }

    public LinkMode mode() {
        return LinkMode.fromInt((int)(this.config & 0xFL));
    }

    public SwitchLink mode(LinkMode rm) {
        this.config = this.config & 0xFFFFFFFFFFFFFFF0L | (long)rm.index();
        return this;
    }

    public static SwitchLink fromNbt(CompoundNBT nbt) {
        return nbt == null ? new SwitchLink() : new SwitchLink(BlockPos.func_218283_e((long)nbt.func_74763_f("p")), nbt.func_74779_i("b"), nbt.func_74763_f("t"));
    }

    public static SwitchLink fromItemStack(ItemStack stack) {
        return stack == null || stack.func_190926_b() || stack.func_77973_b() != ModContent.SWITCH_LINK_PEARL ? new SwitchLink() : SwitchLink.fromNbt(stack.func_77978_p());
    }

    public static SwitchLink fromTargetPosition(World world, BlockPos pos) {
        if (pos == null) {
            return new SwitchLink();
        }
        BlockState state = world.func_180495_p(pos);
        if (state == null || !(state.func_177230_c() instanceof ISwitchLinkable)) {
            return new SwitchLink();
        }
        if (!((ISwitchLinkable)state.func_177230_c()).switchLinkHasTargetSupport(world, pos)) {
            return new SwitchLink();
        }
        return new SwitchLink(pos, state.func_177230_c().getRegistryName().toString(), 0L);
    }

    public static SwitchLink fromPlayerActiveItem(World world, PlayerEntity player) {
        if (player == null || world.func_201670_d() || player.field_71071_by == null || player.field_71071_by.func_70448_g() == null) {
            return new SwitchLink();
        }
        if (player.field_71071_by.func_70448_g().func_77973_b() != ModContent.SWITCH_LINK_PEARL) {
            return null;
        }
        return SwitchLink.fromNbt(player.field_71071_by.func_70448_g().func_77978_p());
    }

    public CompoundNBT toNbt() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("b", this.block_name);
        nbt.func_74772_a("t", this.config);
        nbt.func_74772_a("p", this.target_position.func_218275_a());
        return nbt;
    }

    public ItemStack toSwitchLinkPearl() {
        ItemStack stack = new ItemStack((IItemProvider)ModContent.SWITCH_LINK_PEARL);
        stack.func_190920_e(1);
        stack.func_77982_d(this.toNbt());
        return stack;
    }

    public int distance(@Nullable BlockPos pos) {
        return pos == null || !this.valid ? -1 : (int)Math.sqrt(this.target_position.func_177951_i((Vector3i)pos));
    }

    public boolean isTooFar(BlockPos pos) {
        return ModConfig.max_switch_linking_distance > 0 && this.distance(pos) > ModConfig.max_switch_linking_distance;
    }

    @Nullable
    private ISwitchLinkable target(World world, BlockPos source_pos) {
        if (ModConfig.without_switch_linking || !this.valid || this.isTooFar(source_pos) || !world.func_175667_e(this.target_position)) {
            return null;
        }
        BlockState target_state = world.func_180495_p(this.target_position);
        Block block = target_state.func_177230_c();
        if (!(block instanceof ISwitchLinkable) || !block.getRegistryName().toString().equals(this.block_name)) {
            return null;
        }
        return (ISwitchLinkable)block;
    }

    public RequestResult trigger(World world, BlockPos source_pos, PlayerEntity player) {
        if (ModConfig.without_switch_linking) {
            return RequestResult.NOT_MATCHED;
        }
        if (!this.valid || world.func_201670_d()) {
            return RequestResult.INVALID_LINKDATA;
        }
        if (this.isTooFar(source_pos) || !world.func_175667_e(this.target_position)) {
            return RequestResult.TOO_FAR;
        }
        BlockState target_state = world.func_180495_p(this.target_position);
        if (target_state == null) {
            return RequestResult.TOO_FAR;
        }
        Block block = target_state.func_177230_c();
        if (!(block instanceof ISwitchLinkable) || !block.getRegistryName().toString().equals(this.block_name)) {
            return RequestResult.TARGET_GONE;
        }
        ISwitchLinkable target = (ISwitchLinkable)block;
        int p = target.switchLinkOutputPower(world, this.target_position).orElse(0);
        this.world = world;
        this.source_position = source_pos;
        this.player = player;
        this.source_digital_power = this.source_analog_power = p <= 0 ? 15 : 0;
        return target.switchLinkTrigger(this);
    }

    public RequestResult trigger(World world, BlockPos source_pos, int analog_power, int digital_power, boolean state_changed) {
        ISwitchLinkable target = this.target(world, source_pos);
        if (target == null) {
            return RequestResult.REJECTED;
        }
        this.player = null;
        this.world = world;
        this.source_position = source_pos;
        this.source_analog_power = analog_power;
        this.source_digital_power = digital_power;
        int target_power = target.switchLinkOutputPower(world, this.target_position).orElse(-1);
        if (target_power < 0) {
            return RequestResult.REJECTED;
        }
        boolean analog = target.switchLinkHasAnalogSupport(world, this.target_position);
        switch (this.mode()) {
            case AS_STATE: {
                if (!(analog ? target_power == analog_power : !state_changed || target_power == 0 == (digital_power == 0))) break;
                return RequestResult.NOT_MATCHED;
            }
            case INV_STATE: {
                if (analog) {
                    this.source_analog_power = analog_power = 15 - analog_power;
                    if (target_power != digital_power) break;
                    return RequestResult.NOT_MATCHED;
                }
                if (state_changed && target_power == 0 == (digital_power == 0)) break;
                return RequestResult.NOT_MATCHED;
            }
            case ACTIVATE: {
                if (state_changed && digital_power != 0) break;
                return RequestResult.NOT_MATCHED;
            }
            case DEACTIVATE: {
                if (state_changed && digital_power == 0) break;
                return RequestResult.NOT_MATCHED;
            }
            case TOGGLE: {
                if (state_changed) break;
                return RequestResult.NOT_MATCHED;
            }
        }
        return target.switchLinkTrigger(this);
    }

    public void unlinkTarget(World world, BlockPos source_pos) {
        ISwitchLinkable target = this.target(world, this.target_position);
        if (target == null) {
            return;
        }
        this.world = world;
        this.source_position = source_pos;
        this.player = null;
        target.switchLinkUnlink(this);
    }

    public void initializeTarget(World world, BlockPos source_pos, int analog_power, int digital_power) {
        ISwitchLinkable target = this.target(world, this.target_position);
        if (target == null) {
            return;
        }
        this.world = world;
        this.source_position = source_pos;
        this.source_analog_power = analog_power;
        this.source_digital_power = digital_power;
        this.player = null;
        target.switchLinkInit(this);
    }

    public static Optional<Integer> getOutputPower(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return !(state.func_177230_c() instanceof ISwitchLinkable) ? Optional.empty() : ((ISwitchLinkable)state.func_177230_c()).switchLinkOutputPower(world, pos);
    }

    public static Optional<Integer> getInputPower(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return !(state.func_177230_c() instanceof ISwitchLinkable) ? Optional.empty() : ((ISwitchLinkable)state.func_177230_c()).switchLinkInputPower(world, pos);
    }

    public static Optional<Integer> getComparatorInput(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return !(state.func_177230_c() instanceof ISwitchLinkable) ? Optional.empty() : ((ISwitchLinkable)state.func_177230_c()).switchLinkComparatorInput(world, pos);
    }

    public static enum RequestResult {
        OK,
        NOT_MATCHED,
        INVALID_LINKDATA,
        TOO_FAR,
        TARGET_GONE,
        REJECTED;

    }

    public static enum LinkMode {
        AS_STATE(0),
        ACTIVATE(1),
        DEACTIVATE(2),
        TOGGLE(3),
        INV_STATE(4);

        private static final LinkMode[] VALUES;
        private static final LinkMode[] BY_INDEX;
        private final int index_;

        private LinkMode(int i) {
            this.index_ = i;
        }

        public int index() {
            return this.index_;
        }

        static LinkMode fromInt(int val) {
            return BY_INDEX[MathHelper.func_76125_a((int)val, (int)0, (int)(VALUES.length - 1))];
        }

        public long toInt() {
            return this.index();
        }

        static {
            VALUES = LinkMode.values();
            BY_INDEX = (LinkMode[])Arrays.stream(LinkMode.values()).sorted(Comparator.comparingInt(v -> v.index_)).toArray(LinkMode[]::new);
        }
    }

    public static interface ISwitchLinkable {
        public boolean switchLinkHasTargetSupport(World var1, BlockPos var2);

        public boolean switchLinkHasSourceSupport(World var1, BlockPos var2);

        public boolean switchLinkHasAnalogSupport(World var1, BlockPos var2);

        public void switchLinkUnlink(SwitchLink var1);

        public void switchLinkInit(SwitchLink var1);

        default public ImmutableList<LinkMode> switchLinkGetSupportedTargetModes() {
            return ImmutableList.of((Object)((Object)LinkMode.AS_STATE), (Object)((Object)LinkMode.ACTIVATE), (Object)((Object)LinkMode.DEACTIVATE), (Object)((Object)LinkMode.TOGGLE), (Object)((Object)LinkMode.INV_STATE));
        }

        public RequestResult switchLinkTrigger(SwitchLink var1);

        public Optional<Integer> switchLinkOutputPower(World var1, BlockPos var2);

        public Optional<Integer> switchLinkInputPower(World var1, BlockPos var2);

        public Optional<Integer> switchLinkComparatorInput(World var1, BlockPos var2);
    }
}

