/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.AutoSwitchBlock;
import wile.rsgauges.blocks.EnvironmentalSensorSwitchBlock;
import wile.rsgauges.blocks.RsDirectedBlock;
import wile.rsgauges.blocks.SwitchBlock;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.Overlay;

public class ComparatorSwitchBlock
extends AutoSwitchBlock {
    public ComparatorSwitchBlock(long config, AbstractBlock.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    public ComparatorSwitchBlock(long config, AbstractBlock.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, null, null);
    }

    @Override
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!this.isAffectedByNeigbour(state, (IWorld)world, pos, fromPos)) {
            return;
        }
        AutoSwitchBlock.AutoSwitchTileEntity te = this.getTe((IWorldReader)world, pos);
        if (!(te instanceof ComparatorSwitchTileEntity)) {
            return;
        }
        ((ComparatorSwitchTileEntity)te).block_updated();
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ComparatorSwitchTileEntity(ModContent.TET_COMPARATOR_SWITCH);
    }

    @Override
    public Optional<Integer> switchLinkOutputPower(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof ComparatorSwitchTileEntity)) {
            return Optional.empty();
        }
        return Optional.of(((ComparatorSwitchTileEntity)te).link_output_power());
    }

    public static class ComparatorSwitchTileEntity
    extends EnvironmentalSensorSwitchBlock.EnvironmentalSensorSwitchTileEntity
    implements ITickableTileEntity {
        private int link_output_power_ = 0;
        private static final Acquisition[] acquisitions = new Acquisition[]{(world, pos, state, side) -> !state.func_185912_n() ? -1 : state.func_185888_a(world, pos), (world, pos, state, side) -> {
            TileEntity te = world.func_175625_s(pos);
            if (te == null) {
                return -1;
            }
            if (te instanceof IInventory) {
                IInventory inventory = (IInventory)te;
                int size = inventory.func_70302_i_();
                int n = 0;
                for (int i = 0; i < size; ++i) {
                    n += inventory.func_70301_a(i).func_190926_b() ? 0 : 1;
                }
                return (int)Math.round((double)n * 15.0 / (double)size);
            }
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
            if (handler == null) {
                return -1;
            }
            int size = handler.getSlots();
            if (size == 0) {
                return 0;
            }
            int n = 0;
            for (int i = 0; i < size; ++i) {
                n += handler.getStackInSlot(i).func_190926_b() ? 0 : 1;
            }
            return (int)Math.round((double)n * 15.0 / (double)size);
        }, (world, pos, state, side) -> {
            TileEntity te = world.func_175625_s(pos);
            if (te == null) {
                return -1;
            }
            if (te instanceof IInventory) {
                IInventory inventory = (IInventory)te;
                int size = inventory.func_70302_i_();
                int n = 0;
                for (int i = 0; i < size; ++i) {
                    n += inventory.func_70301_a(i).func_190926_b() ? 1 : 0;
                }
                return (int)Math.round((double)n * 15.0 / (double)size);
            }
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
            if (handler == null) {
                return -1;
            }
            int size = handler.getSlots();
            if (size == 0) {
                return 0;
            }
            int n = 0;
            for (int i = 0; i < size; ++i) {
                n += handler.getStackInSlot(i).func_190926_b() ? 1 : 0;
            }
            return (int)Math.round((double)n * 15.0 / (double)size);
        }, (world, pos, state, side) -> world.func_175651_c(pos, side)};

        public int link_output_power() {
            return this.link_output_power_;
        }

        public ComparatorSwitchTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        public ComparatorSwitchTileEntity() {
            super(ModContent.TET_COMPARATOR_SWITCH);
        }

        private int acquisition_mode() {
            return this.debounce();
        }

        private void acquisition_mode(int mode) {
            this.debounce(MathHelper.func_76125_a((int)mode, (int)0, (int)(acquisitions.length - 1)));
        }

        public void block_updated() {
            if (this.update_timer_ > 1) {
                this.update_timer_ = 1;
            }
        }

        @Override
        public void reset(IWorldReader world) {
            super.reset(world);
            this.on_power(15);
            this.threshold0_on(1.0);
            this.threshold0_off(0.0);
            this.debounce(0);
        }

        @Override
        public boolean activation_config(BlockState state, @Nullable PlayerEntity player, double x, double y, boolean show_only) {
            int field;
            int direction;
            if (state == null) {
                return false;
            }
            SwitchBlock block = (SwitchBlock)state.func_177230_c();
            int n = y >= 9.0 ? 1 : (direction = y <= 6.0 ? -1 : 0);
            int n2 = x >= 2.0 && x <= 3.95 ? 1 : (x >= 4.25 && x <= 7.0 ? 2 : (x >= 8.0 && x <= 10.0 ? 3 : (field = x >= 11.0 && x <= 13.0 ? 4 : 0)));
            if (direction == 0 || field == 0) {
                return false;
            }
            if (!show_only) {
                switch (field) {
                    case 1: {
                        double v = this.threshold0_on() + (double)direction;
                        if (v < 1.0) {
                            v = 1.0;
                        } else if (v > 15.0) {
                            v = 15.0;
                        }
                        this.threshold0_on(v);
                        if (!(this.threshold0_on() < this.threshold0_off())) break;
                        this.threshold0_off(this.threshold0_on());
                        break;
                    }
                    case 2: {
                        double v = this.threshold0_off() + (double)direction;
                        if (v < 0.0) {
                            v = 0.0;
                        } else if (v > 14.0) {
                            v = 14.0;
                        }
                        this.threshold0_off(v);
                        if (!(this.threshold0_off() > this.threshold0_on())) break;
                        this.threshold0_on(this.threshold0_off());
                        break;
                    }
                    case 3: {
                        this.acquisition_mode(this.acquisition_mode() + direction);
                        break;
                    }
                    case 4: {
                        this.on_power(this.on_power() + direction);
                    }
                }
                if (this.on_power() < 1) {
                    this.on_power(1);
                }
                this.func_70296_d();
            }
            StringTextComponent separator = new StringTextComponent(" | ");
            separator.func_240699_a_(TextFormatting.GRAY);
            ArrayList<Object> tr = new ArrayList<Object>();
            tr.add(Auxiliaries.localizable("switchconfig.comparator_switch.threshold_on", TextFormatting.BLUE, new Object[]{(int)this.threshold0_on()}));
            tr.add(separator.func_230532_e_().func_230529_a_((ITextComponent)Auxiliaries.localizable("switchconfig.comparator_switch.threshold_off", TextFormatting.YELLOW, new Object[]{(int)this.threshold0_off()})));
            tr.add(separator.func_230532_e_().func_230529_a_((ITextComponent)Auxiliaries.localizable("switchconfig.comparator_switch.output_power", TextFormatting.RED, new Object[]{this.on_power()})));
            tr.add(separator.func_230532_e_().func_230529_a_((ITextComponent)Auxiliaries.localizable("switchconfig.comparator_switch.mode" + this.acquisition_mode(), TextFormatting.DARK_GREEN, new Object[0])));
            tr.add(separator.func_230532_e_().func_230529_a_((ITextComponent)Auxiliaries.localizable("switchconfig.comparator_switch.output_power", TextFormatting.RED, new Object[]{this.on_power()})));
            Overlay.show(player, (ITextComponent)Auxiliaries.localizable("switchconfig.comparator_switch", TextFormatting.RESET, tr.toArray()));
            return true;
        }

        @Override
        public int power(BlockState state, boolean strong) {
            return this.acquisition_mode() == 3 ? 0 : super.power(state, strong);
        }

        @Override
        public void func_73660_a() {
            boolean last_active;
            if (!this.func_145830_o() || this.func_145831_w().func_201670_d() || --this.update_timer_ > 0) {
                return;
            }
            if (this.update_interval_ < 4) {
                this.update_interval_ = 4;
            }
            this.update_timer_ = this.update_interval_ + (int)(Math.random() * 2.0);
            BlockState state = this.func_195044_w();
            if (!(state.func_177230_c() instanceof ComparatorSwitchBlock)) {
                return;
            }
            boolean active = last_active = ((Boolean)state.func_177229_b((Property)SwitchBlock.POWERED)).booleanValue();
            Direction facing = (Direction)state.func_177229_b((Property)RsDirectedBlock.FACING);
            BlockPos adjacent_pos = this.func_174877_v().func_177972_a(facing.func_176734_d());
            BlockState adjacent_state = this.func_145831_w().func_180495_p(adjacent_pos);
            this.acquisition_mode(this.acquisition_mode());
            int value = MathHelper.func_76125_a((int)acquisitions[this.acquisition_mode()].sample(this.field_145850_b, adjacent_pos, adjacent_state, facing), (int)-1, (int)15);
            int last_link_output_power = this.link_output_power_;
            if (value < 0) {
                active = false;
                this.update_timer_ = 20;
                this.link_output_power_ = 0;
            } else {
                this.link_output_power_ = value;
                int measurement = 0;
                if (this.threshold0_off() >= this.threshold0_on()) {
                    measurement += (double)value == this.threshold0_on() ? 1 : -1;
                } else {
                    if ((double)value >= this.threshold0_on()) {
                        measurement = 1;
                    }
                    if ((double)value <= this.threshold0_off()) {
                        measurement = -1;
                    }
                }
                this.debounce_counter_ += measurement;
                if (this.debounce_counter_ <= 0) {
                    active = false;
                    this.debounce_counter_ = 0;
                } else if (this.debounce_counter_ >= 2) {
                    active = true;
                    this.debounce_counter_ = 2;
                }
            }
            this.updateSwitchState(state, (ComparatorSwitchBlock)state.func_177230_c(), active, 0, false);
            if (!(this.link_output_power_ == last_link_output_power && last_active == active || this.activateSwitchLinks(this.link_output_power_, active ? 15 : 0, last_active != active))) {
                ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(this.field_145850_b, this.field_174879_c);
            }
        }

        private static interface Acquisition {
            public int sample(World var1, BlockPos var2, BlockState var3, Direction var4);
        }
    }
}

