/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.mod.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.rhino.mod.util.ChangeListener;
import dev.latvian.mods.rhino.mod.util.CollectionTagWrapper;
import dev.latvian.mods.rhino.mod.util.JsonSerializable;
import dev.latvian.mods.rhino.mod.util.JsonUtils;
import dev.latvian.mods.rhino.util.MapLike;
import java.util.Collection;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.EndNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.StringNBT;
import org.jetbrains.annotations.Nullable;

public class CompoundTagWrapper
implements MapLike<String, Object>,
JsonSerializable,
ChangeListener<INBT> {
    public final CompoundNBT minecraftTag;
    public ChangeListener<INBT> listener;

    public static Object unwrap(@Nullable INBT t, @Nullable ChangeListener<INBT> l) {
        if (t == null || t instanceof EndNBT) {
            return null;
        }
        if (t instanceof StringNBT) {
            return t.func_150285_a_();
        }
        if (t instanceof NumberNBT) {
            return ((NumberNBT)t).func_209908_j();
        }
        if (t instanceof CompoundNBT) {
            CompoundTagWrapper c = new CompoundTagWrapper((CompoundNBT)t);
            c.listener = l;
            return c;
        }
        if (t instanceof CollectionNBT) {
            CollectionTagWrapper c = new CollectionTagWrapper((CollectionNBT)t);
            c.listener = l;
            return c;
        }
        return t;
    }

    public static INBT wrap(@Nullable Object o) {
        if (o instanceof INBT) {
            return (INBT)o;
        }
        if (o instanceof Number) {
            return DoubleNBT.func_229684_a_((double)((Number)o).doubleValue());
        }
        if (o instanceof CharSequence) {
            return StringNBT.func_229705_a_((String)o.toString());
        }
        if (o instanceof CompoundTagWrapper) {
            return ((CompoundTagWrapper)o).minecraftTag;
        }
        if (o instanceof CollectionTagWrapper) {
            return ((CollectionTagWrapper)o).minecraftTag;
        }
        return null;
    }

    public CompoundTagWrapper(CompoundNBT t) {
        this.minecraftTag = t;
    }

    @Override
    public Object getML(String key) {
        return CompoundTagWrapper.unwrap(this.minecraftTag.func_74781_a(key), this);
    }

    @Override
    public void putML(String key, Object value) {
        INBT t = CompoundTagWrapper.wrap(value);
        if (t != null) {
            this.minecraftTag.func_218657_a(key, t);
            if (this.listener != null) {
                this.listener.onChanged((INBT)this.minecraftTag);
            }
        }
    }

    @Override
    public boolean containsKeyML(String key) {
        return this.minecraftTag.func_74764_b(key);
    }

    @Override
    public Collection<String> keysML() {
        return this.minecraftTag.func_150296_c();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        for (String key : this.minecraftTag.func_150296_c()) {
            JsonElement e = JsonUtils.of(CompoundTagWrapper.unwrap(this.minecraftTag.func_74781_a(key), this));
            if (e.isJsonNull()) continue;
            json.add(key, e);
        }
        return json;
    }

    @Override
    public void onChanged(INBT o) {
        if (this.listener != null) {
            this.listener.onChanged((INBT)this.minecraftTag);
        }
    }
}

