/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.playerprops;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mcjty.lib.varia.LevelTools;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;

public class FavoriteDestinationsProperties {
    private Set<GlobalPos> favoriteDestinations = new HashSet<GlobalPos>();

    public void copyFrom(FavoriteDestinationsProperties source) {
        this.favoriteDestinations = new HashSet<GlobalPos>(source.favoriteDestinations);
    }

    public boolean isDestinationFavorite(GlobalPos coordinate) {
        return this.favoriteDestinations.contains(coordinate);
    }

    public void setDestinationFavorite(GlobalPos coordinate, boolean favorite) {
        if (favorite) {
            this.favoriteDestinations.add(coordinate);
        } else {
            this.favoriteDestinations.remove(coordinate);
        }
    }

    public void saveNBTData(CompoundNBT compound) {
        FavoriteDestinationsProperties.writeFavoritesToNBT(compound, this.favoriteDestinations);
    }

    private static void writeFavoritesToNBT(CompoundNBT tagCompound, Collection<GlobalPos> destinations) {
        ListNBT lst = new ListNBT();
        for (GlobalPos destination : destinations) {
            CompoundNBT tc = new CompoundNBT();
            BlockPos c = destination.func_218180_b();
            tc.func_74768_a("x", c.func_177958_n());
            tc.func_74768_a("y", c.func_177956_o());
            tc.func_74768_a("z", c.func_177952_p());
            tc.func_74778_a("dim", destination.func_239646_a_().func_240901_a_().toString());
            lst.add((Object)tc);
        }
        tagCompound.func_218657_a("destinations", (INBT)lst);
    }

    public void loadNBTData(CompoundNBT compound) {
        this.favoriteDestinations.clear();
        FavoriteDestinationsProperties.readCoordinatesFromNBT(compound, this.favoriteDestinations);
    }

    private static void readCoordinatesFromNBT(CompoundNBT tagCompound, Set<GlobalPos> destinations) {
        ListNBT lst = tagCompound.func_150295_c("destinations", 10);
        for (int i = 0; i < lst.size(); ++i) {
            CompoundNBT tc = lst.func_150305_b(i);
            BlockPos c = new BlockPos(tc.func_74762_e("x"), tc.func_74762_e("y"), tc.func_74762_e("z"));
            destinations.add(GlobalPos.func_239648_a_((RegistryKey)LevelTools.getId((String)tc.func_74779_i("dim")), (BlockPos)c));
        }
    }
}

