/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.LogicFacing;
import mcjty.lib.varia.NamedEnum;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.tools.AreaType;
import mcjty.rftoolsutility.modules.logic.tools.GroupType;
import mcjty.rftoolsutility.modules.logic.tools.SensorType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;

public class SensorTileEntity
extends TickingTileEntity {
    private final LogicSupport support = new LogicSupport();
    public static final int SLOT_ITEMMATCH = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).slot(SlotDefinition.ghost(), 0, 154, 24).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid(GenericItemHandler.no()).build();
    @Cap(type=CapType.CONTAINER)
    private LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Sensor").containerSupplier(DefaultContainerProvider.container(LogicBlockModule.CONTAINER_SENSOR, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    @GuiValue
    private int number = 0;
    private SensorType sensorType = SensorType.SENSOR_BLOCK;
    @GuiValue
    public static final Value<SensorTileEntity, String> VALUE_TYPE = Value.createEnum((String)"type", (NamedEnum[])SensorType.values(), SensorTileEntity::getSensorType, SensorTileEntity::setSensorType);
    private AreaType areaType = AreaType.AREA_1;
    @GuiValue
    public static final Value<SensorTileEntity, String> VALUE_AREA = Value.createEnum((String)"area", (NamedEnum[])AreaType.values(), SensorTileEntity::getAreaType, SensorTileEntity::setAreaType);
    private GroupType groupType = GroupType.GROUP_ONE;
    @GuiValue
    public static final Value<SensorTileEntity, String> VALUE_GROUP = Value.createEnum((String)"group", (NamedEnum[])GroupType.values(), SensorTileEntity::getGroupType, SensorTileEntity::setGroupType);
    private int checkCounter = 0;
    private AxisAlignedBB cachedBox = null;

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsutility:logic/sensor")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(SensorTileEntity::new));
    }

    public SensorTileEntity() {
        super((TileEntityType)LogicBlockModule.TYPE_SENSOR.get());
    }

    public int getNumber() {
        return this.number;
    }

    public SensorType getSensorType() {
        return this.sensorType;
    }

    public void setSensorType(SensorType sensorType) {
        this.sensorType = sensorType;
        this.cachedBox = null;
        this.func_70296_d();
    }

    public AreaType getAreaType() {
        return this.areaType;
    }

    public void setAreaType(AreaType areaType) {
        this.areaType = areaType;
        this.cachedBox = null;
        this.func_70296_d();
    }

    public GroupType getGroupType() {
        return this.groupType;
    }

    public void setGroupType(GroupType groupType) {
        this.groupType = groupType;
        this.cachedBox = null;
        this.func_70296_d();
    }

    protected void tickServer() {
        --this.checkCounter;
        if (this.checkCounter > 0) {
            return;
        }
        this.checkCounter = 10;
        this.support.setRedstoneState((GenericTileEntity)this, this.checkSensor() ? 15 : 0);
    }

    public void checkRedstone(World world, BlockPos pos) {
        this.support.checkRedstone((GenericTileEntity)this, world, pos);
    }

    public int getRedstoneOutput(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }

    public boolean checkSensor() {
        boolean newout;
        LogicFacing facing = LogicSupport.getFacing((BlockState)this.field_145850_b.func_180495_p(this.func_174877_v()));
        Direction inputSide = facing.getInputSide();
        BlockPos newpos = this.func_174877_v().func_177972_a(inputSide);
        switch (this.sensorType) {
            case SENSOR_BLOCK: {
                newout = this.checkBlockOrFluid(newpos, facing, inputSide, this::checkBlock);
                break;
            }
            case SENSOR_FLUID: {
                newout = this.checkBlockOrFluid(newpos, facing, inputSide, this::checkFluid);
                break;
            }
            case SENSOR_GROWTHLEVEL: {
                newout = this.checkGrowthLevel(newpos, facing, inputSide);
                break;
            }
            case SENSOR_ENTITIES: {
                newout = this.checkEntities(newpos, facing, inputSide, Entity.class);
                break;
            }
            case SENSOR_PLAYERS: {
                newout = this.checkEntities(newpos, facing, inputSide, PlayerEntity.class);
                break;
            }
            case SENSOR_HOSTILE: {
                newout = this.checkEntitiesHostile(newpos, facing, inputSide);
                break;
            }
            case SENSOR_PASSIVE: {
                newout = this.checkEntitiesPassive(newpos, facing, inputSide);
                break;
            }
            default: {
                newout = false;
            }
        }
        return newout;
    }

    private boolean checkBlockOrFluid(BlockPos newpos, LogicFacing facing, Direction dir, Function<BlockPos, Boolean> blockChecker) {
        int blockCount = this.areaType.getBlockCount();
        if (blockCount > 0) {
            Boolean x = this.checkBlockOrFluidRow(newpos, dir, blockChecker, blockCount);
            if (x != null) {
                return x;
            }
        } else if (blockCount < 0) {
            Direction downSide = facing.getSide();
            Direction inputSide = facing.getInputSide();
            Direction rightSide = LogicSlabBlock.rotateLeft((Direction)downSide, (Direction)inputSide);
            Direction leftSide = LogicSlabBlock.rotateRight((Direction)downSide, (Direction)inputSide);
            Boolean x = this.checkBlockOrFluidRow(newpos, dir, blockChecker, blockCount = -blockCount);
            if (x != null) {
                return x;
            }
            for (int i = 1; i <= (blockCount - 1) / 2; ++i) {
                BlockPos p = newpos.func_177967_a(leftSide, i);
                x = this.checkBlockOrFluidRow(p, dir, blockChecker, blockCount);
                if (x != null) {
                    return x;
                }
                p = newpos.func_177967_a(rightSide, i);
                x = this.checkBlockOrFluidRow(p, dir, blockChecker, blockCount);
                if (x == null) continue;
                return x;
            }
        }
        return this.groupType == GroupType.GROUP_ALL;
    }

    private Boolean checkBlockOrFluidRow(BlockPos newpos, Direction dir, Function<BlockPos, Boolean> blockChecker, int count) {
        for (int i = 0; i < count; ++i) {
            boolean result = blockChecker.apply(newpos);
            if (result && this.groupType == GroupType.GROUP_ONE) {
                return true;
            }
            if (!result && this.groupType == GroupType.GROUP_ALL) {
                return false;
            }
            newpos = newpos.func_177972_a(dir);
        }
        return null;
    }

    private boolean checkBlock(BlockPos newpos) {
        BlockState state = this.field_145850_b.func_180495_p(newpos);
        ItemStack matcher = this.items.getStackInSlot(0);
        if (matcher.func_190926_b()) {
            return state.func_200132_m();
        }
        ItemStack stack = state.func_177230_c().func_185473_a((IBlockReader)this.field_145850_b, newpos, state);
        if (!stack.func_190926_b()) {
            return matcher.func_77973_b() == stack.func_77973_b();
        }
        return matcher.func_77973_b() == state.func_177230_c().func_199767_j();
    }

    private boolean checkFluid(BlockPos newpos) {
        BlockState state = this.field_145850_b.func_180495_p(newpos);
        ItemStack matcher = this.items.getStackInSlot(0);
        Block block = state.func_177230_c();
        if (matcher.func_190926_b()) {
            if (block instanceof FlowingFluidBlock || block instanceof IFluidBlock) {
                return !block.isAir(state, (IBlockReader)this.field_145850_b, newpos);
            }
            return false;
        }
        ItemStack stack = block.func_185473_a((IBlockReader)this.field_145850_b, newpos, state);
        Item matcherItem = matcher.func_77973_b();
        FluidStack matcherFluidStack = null;
        if (matcherItem instanceof BucketItem) {
            matcherFluidStack = new FluidBucketWrapper(matcher).getFluid();
            return this.checkFluid(block, matcherFluidStack, state, newpos);
        }
        return false;
    }

    private boolean checkFluid(Block block, FluidStack matcherFluidStack, BlockState state, BlockPos newpos) {
        if (matcherFluidStack == null) {
            return block.isAir(state, (IBlockReader)this.field_145850_b, newpos);
        }
        Fluid matcherFluid = matcherFluidStack.getFluid();
        if (matcherFluid == null) {
            return false;
        }
        Block matcherFluidBlock = matcherFluid.func_207188_f().func_206883_i().func_177230_c();
        return matcherFluidBlock == block;
    }

    private boolean checkGrowthLevel(BlockPos newpos, LogicFacing facing, Direction dir) {
        int blockCount = this.areaType.getBlockCount();
        if (blockCount > 0) {
            Boolean x = this.checkGrowthLevelRow(newpos, dir, blockCount);
            if (x != null) {
                return x;
            }
        } else if (blockCount < 0) {
            Direction downSide = facing.getSide();
            Direction inputSide = facing.getInputSide();
            Direction rightSide = LogicSlabBlock.rotateLeft((Direction)downSide, (Direction)inputSide);
            Direction leftSide = LogicSlabBlock.rotateRight((Direction)downSide, (Direction)inputSide);
            Boolean x = this.checkGrowthLevelRow(newpos, dir, blockCount = -blockCount);
            if (x != null) {
                return x;
            }
            for (int i = 1; i <= (blockCount - 1) / 2; ++i) {
                BlockPos p = newpos.func_177967_a(leftSide, i);
                x = this.checkGrowthLevelRow(p, dir, blockCount);
                if (x != null) {
                    return x;
                }
                p = newpos.func_177967_a(rightSide, i);
                x = this.checkGrowthLevelRow(p, dir, blockCount);
                if (x == null) continue;
                return x;
            }
        }
        return this.groupType == GroupType.GROUP_ALL;
    }

    private Boolean checkGrowthLevelRow(BlockPos newpos, Direction dir, int blockCount) {
        for (int i = 0; i < blockCount; ++i) {
            boolean result = this.checkGrowthLevel(newpos);
            if (result && this.groupType == GroupType.GROUP_ONE) {
                return true;
            }
            if (!result && this.groupType == GroupType.GROUP_ALL) {
                return false;
            }
            newpos = newpos.func_177972_a(dir);
        }
        return null;
    }

    private boolean checkGrowthLevel(BlockPos newpos) {
        BlockState state = this.field_145850_b.func_180495_p(newpos);
        int pct = 0;
        for (Property property : state.func_235904_r_()) {
            if (!"age".equals(property.func_177701_a())) continue;
            if (property.func_177699_b() != Integer.class) break;
            Property integerProperty = property;
            int age = (Integer)state.func_177229_b(integerProperty);
            int maxAge = (Integer)Collections.max(integerProperty.func_177700_c());
            pct = age * 100 / maxAge;
            break;
        }
        return pct >= this.number;
    }

    public void invalidateCache() {
        this.cachedBox = null;
    }

    private AxisAlignedBB getCachedBox(BlockPos pos1, LogicFacing facing, Direction dir) {
        if (this.cachedBox == null) {
            int n = this.areaType.getBlockCount();
            if (n > 0) {
                this.cachedBox = new AxisAlignedBB(pos1);
                if (n > 1) {
                    BlockPos pos2 = pos1.func_177967_a(dir, n - 1);
                    this.cachedBox = this.cachedBox.func_111270_a(new AxisAlignedBB(pos2));
                }
                this.cachedBox = this.cachedBox.func_72321_a(0.1, 0.1, 0.1);
            } else {
                BlockPos pos2;
                n = -n;
                this.cachedBox = new AxisAlignedBB(pos1);
                Direction downSide = facing.getSide();
                Direction inputSide = facing.getInputSide();
                Direction rightSide = LogicSlabBlock.rotateLeft((Direction)downSide, (Direction)inputSide);
                Direction leftSide = LogicSlabBlock.rotateRight((Direction)downSide, (Direction)inputSide);
                if (n > 1) {
                    pos2 = pos1.func_177967_a(dir, n - 1);
                    this.cachedBox = this.cachedBox.func_111270_a(new AxisAlignedBB(pos2));
                }
                pos2 = pos1.func_177967_a(leftSide, (n - 1) / 2);
                this.cachedBox = this.cachedBox.func_111270_a(new AxisAlignedBB(pos2));
                pos2 = pos1.func_177967_a(rightSide, (n - 1) / 2);
                this.cachedBox = this.cachedBox.func_111270_a(new AxisAlignedBB(pos2));
            }
        }
        return this.cachedBox;
    }

    private boolean checkEntities(BlockPos pos1, LogicFacing facing, Direction dir, Class<? extends Entity> clazz) {
        List entities = this.field_145850_b.func_217357_a(clazz, this.getCachedBox(pos1, facing, dir));
        return entities.size() >= this.number;
    }

    private boolean checkEntitiesHostile(BlockPos pos1, LogicFacing facing, Direction dir) {
        List entities = this.field_145850_b.func_217357_a(CreatureEntity.class, this.getCachedBox(pos1, facing, dir));
        int cnt = 0;
        for (Entity entity : entities) {
            if (!(entity instanceof IMob) || ++cnt < this.number) continue;
            return true;
        }
        return false;
    }

    private boolean checkEntitiesPassive(BlockPos pos1, LogicFacing facing, Direction dir) {
        List entities = this.field_145850_b.func_217357_a(CreatureEntity.class, this.getCachedBox(pos1, facing, dir));
        int cnt = 0;
        for (Entity entity : entities) {
            if (!(entity instanceof MobEntity) || entity instanceof IMob || ++cnt < this.number) continue;
            return true;
        }
        return false;
    }

    public void load(CompoundNBT tagCompound) {
        super.load(tagCompound);
        this.support.setPowerOutput(tagCompound.func_74767_n("rs") ? 15 : 0);
    }

    public void loadInfo(CompoundNBT tagCompound) {
        super.loadInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.number = info.func_74762_e("number");
        this.sensorType = SensorType.values()[info.func_74771_c("sensor")];
        this.areaType = AreaType.values()[info.func_74771_c("area")];
        this.groupType = GroupType.values()[info.func_74771_c("group")];
    }

    public void saveAdditional(@Nonnull CompoundNBT tagCompound) {
        super.saveAdditional(tagCompound);
        tagCompound.func_74757_a("rs", this.support.getPowerOutput() > 0);
    }

    public void saveInfo(CompoundNBT tagCompound) {
        super.saveInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("number", this.number);
        info.func_74774_a("sensor", (byte)this.sensorType.ordinal());
        info.func_74774_a("area", (byte)this.areaType.ordinal());
        info.func_74774_a("group", (byte)this.groupType.ordinal());
    }

    public void rotateBlock(Rotation axis) {
        this.invalidateCache();
    }
}

