/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.blocks.RedstoneChannelBlock;
import mcjty.rftoolsutility.modules.logic.blocks.RedstoneChannelTileEntity;
import mcjty.rftoolsutility.modules.logic.tools.RedstoneChannels;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.util.LazyOptional;

public class RedstoneReceiverTileEntity
extends RedstoneChannelTileEntity
implements ITickableTileEntity {
    @GuiValue
    private boolean analog = false;
    @Cap(type=CapType.CONTAINER)
    private LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Redstone Receiver").containerSupplier(DefaultContainerProvider.empty(LogicBlockModule.CONTAINER_REDSTONE_RECEIVER, (GenericTileEntity)this)).setupSync((GenericTileEntity)this));

    public RedstoneReceiverTileEntity() {
        super((TileEntityType)LogicBlockModule.TYPE_REDSTONE_RECEIVER.get());
    }

    public static RedstoneChannelBlock createBlock() {
        return new RedstoneChannelBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsutility:logic/redstone_receiver")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"channel", RedstoneChannelBlock::getChannelString)}).tileEntitySupplier(RedstoneReceiverTileEntity::new));
    }

    public boolean getAnalog() {
        return this.analog;
    }

    public void setAnalog(boolean analog) {
        this.analog = analog;
        this.func_70296_d();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.support.setRedstoneState((GenericTileEntity)this, this.checkOutput());
        }
    }

    public int checkOutput() {
        RedstoneChannels channels;
        RedstoneChannels.RedstoneChannel ch;
        if (this.channel != -1 && (ch = (channels = RedstoneChannels.getChannels(this.field_145850_b)).getChannel(this.channel)) != null) {
            int newout = ch.getValue();
            if (!this.analog && newout > 0) {
                return 15;
            }
            return newout;
        }
        return 0;
    }

    public void load(CompoundNBT tagCompound) {
        super.load(tagCompound);
        this.support.setPowerOutput(tagCompound.func_74762_e("rs"));
    }

    public void saveAdditional(@Nonnull CompoundNBT tagCompound) {
        super.saveAdditional(tagCompound);
        tagCompound.func_74768_a("rs", this.support.getPowerOutput());
    }

    @Override
    public void loadInfo(CompoundNBT tagCompound) {
        super.loadInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.analog = info.func_74767_n("analog");
    }

    @Override
    public void saveInfo(CompoundNBT tagCompound) {
        super.saveInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74757_a("analog", this.analog);
    }
}

