/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.crafter.blocks;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.UndoableItemHandler;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.Cached;
import mcjty.lib.varia.InventoryTools;
import mcjty.lib.varia.ItemStackList;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.NamedEnum;
import mcjty.rftoolsbase.api.compat.JEIRecipeAcceptor;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleItem;
import mcjty.rftoolsutility.modules.crafter.CrafterConfiguration;
import mcjty.rftoolsutility.modules.crafter.blocks.CrafterContainer;
import mcjty.rftoolsutility.modules.crafter.data.CraftMode;
import mcjty.rftoolsutility.modules.crafter.data.CraftingRecipe;
import mcjty.rftoolsutility.modules.crafter.data.KeepMode;
import mcjty.rftoolsutility.modules.crafter.data.SpeedMode;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CrafterBaseTE
extends TickingTileEntity
implements JEIRecipeAcceptor {
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CrafterContainer.CONTAINER_FACTORY).itemValid(this::isItemValidForSlot).onUpdate((slot, stack) -> this.clearCacheOrUpdateRecipe((Integer)slot)).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)CrafterConfiguration.MAXENERGY.get()).intValue(), (long)((Integer)CrafterConfiguration.RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Crafter").containerSupplier((windowId, player) -> new CrafterContainer((int)windowId, (ContainerFactory)CrafterContainer.CONTAINER_FACTORY.get(), this.func_174877_v(), (GenericTileEntity)this, (PlayerEntity)player)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((TileEntity)this));
    private final ItemStackList ghostSlots = ItemStackList.create((int)30);
    private final CraftingRecipe[] recipes;
    private final Cached<Predicate<ItemStack>> filterCache = Cached.of(this::createFilterCache);
    @GuiValue
    private SpeedMode speedMode = SpeedMode.SLOW;
    private int selected = -1;
    @GuiValue
    public static final Value<CrafterBaseTE, Integer> SELECTED = Value.create((String)"selected", (Type)Type.INTEGER, CrafterBaseTE::getSelected, CrafterBaseTE::setSelected);
    @GuiValue
    public static final Value<CrafterBaseTE, String> CRAFT_MODE = Value.createEnum((String)"craftMode", (NamedEnum[])CraftMode.values(), CrafterBaseTE::getCraftMode, CrafterBaseTE::setCraftMode);
    @GuiValue
    public static final Value<CrafterBaseTE, String> KEEP_ONE = Value.createEnum((String)"keepOne", (NamedEnum[])KeepMode.values(), CrafterBaseTE::getKeepOne, CrafterBaseTE::setKeepOne);
    public boolean noRecipesWork = false;
    private final CraftingInventory workInventory = new CraftingInventory(new Container(null, -1){

        public boolean func_75145_c(PlayerEntity var1) {
            return false;
        }
    }, 3, 3);
    @ServerCommand
    public static final Command<?> CMD_REMEMBER = Command.create((String)"crafter.remember", (te, player, params) -> te.rememberItems());
    @ServerCommand
    public static final Command<?> CMD_FORGET = Command.create((String)"crafter.forget", (te, player, params) -> te.forgetItems());
    @ServerCommand
    public static final Command<?> CMD_APPLY = Command.create((String)"crafter.apply", (te, player, params) -> te.applyRecipe());

    private void clearCacheOrUpdateRecipe(Integer slot) {
        this.noRecipesWork = false;
        if (slot == 40) {
            this.filterCache.clear();
        } else if (slot >= 0 && slot < 9) {
            for (int i = 0; i < 9; ++i) {
                this.workInventory.func_70299_a(i, this.items.getStackInSlot(i + 0).func_77946_l());
            }
            IRecipe recipe = CraftingRecipe.findRecipe(this.field_145850_b, this.workInventory);
            if (recipe != null) {
                ItemStack result = recipe.func_77572_b((IInventory)this.workInventory);
                this.items.setStackInSlot(9, result);
            } else {
                this.items.setStackInSlot(9, ItemStack.field_190927_a);
            }
        }
    }

    public CrafterBaseTE(TileEntityType type, int supportedRecipes) {
        super(type);
        this.recipes = new CraftingRecipe[supportedRecipes];
        for (int i = 0; i < this.recipes.length; ++i) {
            this.recipes[i] = new CraftingRecipe();
        }
    }

    public int getSelected() {
        return this.selected;
    }

    private void setSelected(int sel) {
        if (sel == this.selected) {
            return;
        }
        this.selected = sel < 0 || sel >= this.recipes.length ? -1 : sel;
        if (this.selected < 0) {
            for (int i = 0; i < 10; ++i) {
                this.items.setStackInSlot(0 + i, ItemStack.field_190927_a);
            }
        } else {
            CraftingRecipe recipe = this.recipes[this.selected];
            this.items.setStackInSlot(9, recipe.getResult());
            CraftingInventory inv = recipe.getInventory();
            int size = inv.func_70302_i_();
            for (int i = 0; i < size; ++i) {
                this.items.setStackInSlot(0 + i, inv.func_70301_a(i));
            }
        }
        this.func_70296_d();
    }

    private void applyRecipe() {
        if (this.selected < 0 || this.selected >= this.recipes.length) {
            return;
        }
        CraftingRecipe recipe = this.recipes[this.selected];
        ItemStack[] recipeItems = new ItemStack[9];
        for (int i = 0; i < 9; ++i) {
            recipeItems[i] = this.items.getStackInSlot(i + 0).func_77946_l();
        }
        recipe.setRecipe(recipeItems, this.items.getStackInSlot(9).func_77946_l());
        this.markDirtyClient();
    }

    private CraftMode getCraftMode() {
        if (this.selected < 0 || this.selected >= this.recipes.length) {
            return CraftMode.EXT;
        }
        return this.recipes[this.selected].getCraftMode();
    }

    private void setCraftMode(CraftMode mode) {
        if (this.selected >= 0 && this.selected < this.recipes.length && this.recipes[this.selected].getCraftMode() != mode) {
            this.recipes[this.selected].setCraftMode(mode);
            this.func_70296_d();
        }
    }

    private KeepMode getKeepOne() {
        if (this.selected < 0 || this.selected >= this.recipes.length) {
            return KeepMode.ALL;
        }
        return this.recipes[this.selected].getKeepOne();
    }

    private void setKeepOne(KeepMode keepOne) {
        if (this.selected >= 0 && this.selected < this.recipes.length) {
            if (this.recipes[this.selected].getKeepOne() != keepOne) {
                this.recipes[this.selected].setKeepOne(keepOne);
            }
            this.func_70296_d();
        }
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public ItemStackList getGhostSlots() {
        return this.ghostSlots;
    }

    public void setGridContents(List<ItemStack> stacks) {
        this.items.setStackInSlot(9, stacks.get(0));
        for (int i = 1; i < stacks.size(); ++i) {
            this.items.setStackInSlot(0 + i - 1, stacks.get(i));
        }
        this.func_70296_d();
    }

    public int getSupportedRecipes() {
        return this.recipes.length;
    }

    public SpeedMode getSpeedMode() {
        return this.speedMode;
    }

    public CraftingRecipe getRecipe(int index) {
        return this.recipes[index];
    }

    public Predicate<ItemStack> createFilterCache() {
        return FilterModuleItem.getCache((ItemStack)this.items.getStackInSlot(40));
    }

    public void saveClientDataToNBT(CompoundNBT tagCompound) {
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        this.writeGhostBufferToNBT(info);
        this.writeRecipesToNBT(info);
    }

    public void loadClientDataFromNBT(CompoundNBT tagCompound) {
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.readGhostBufferFromNBT(info);
        this.readRecipesFromNBT(info);
    }

    public void load(CompoundNBT tagCompound) {
        super.load(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.readGhostBufferFromNBT(info);
        this.readRecipesFromNBT(info);
        this.speedMode = SpeedMode.values()[info.func_74771_c("speedMode")];
    }

    private void readGhostBufferFromNBT(CompoundNBT tagCompound) {
        ListNBT bufferTagList = tagCompound.func_150295_c("GItems", 10);
        for (int i = 0; i < bufferTagList.size(); ++i) {
            this.ghostSlots.set(i, (Object)ItemStack.func_199557_a((CompoundNBT)bufferTagList.func_150305_b(i)));
        }
    }

    private void readRecipesFromNBT(CompoundNBT tagCompound) {
        ListNBT recipeTagList = tagCompound.func_150295_c("Recipes", 10);
        for (int i = 0; i < recipeTagList.size(); ++i) {
            this.recipes[i].readFromNBT(recipeTagList.func_150305_b(i));
        }
    }

    public void saveAdditional(@Nonnull CompoundNBT tagCompound) {
        super.saveAdditional(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        this.writeGhostBufferToNBT(info);
        this.writeRecipesToNBT(info);
        info.func_74774_a("speedMode", (byte)this.speedMode.ordinal());
    }

    private void writeGhostBufferToNBT(CompoundNBT tagCompound) {
        ListNBT bufferTagList = new ListNBT();
        for (ItemStack stack : this.ghostSlots) {
            CompoundNBT CompoundNBT2 = new CompoundNBT();
            if (!stack.func_190926_b()) {
                stack.func_77955_b(CompoundNBT2);
            }
            bufferTagList.add((Object)CompoundNBT2);
        }
        tagCompound.func_218657_a("GItems", (INBT)bufferTagList);
    }

    private void writeRecipesToNBT(CompoundNBT tagCompound) {
        ListNBT recipeTagList = new ListNBT();
        for (CraftingRecipe recipe : this.recipes) {
            CompoundNBT CompoundNBT2 = new CompoundNBT();
            recipe.writeToNBT(CompoundNBT2);
            recipeTagList.add((Object)CompoundNBT2);
        }
        tagCompound.func_218657_a("Recipes", (INBT)recipeTagList);
    }

    protected void tickServer() {
        int i;
        int steps;
        if (!this.isMachineEnabled() || this.noRecipesWork) {
            return;
        }
        int defaultCost = (Integer)CrafterConfiguration.rfPerOperation.get();
        int rf = this.infusableHandler.map(inf -> (int)((float)defaultCost * (2.0f - inf.getInfusedFactor()) / 2.0f)).orElse(defaultCost);
        int n = steps = this.speedMode == SpeedMode.FAST ? (Integer)CrafterConfiguration.speedOperations.get() : 1;
        if (rf > 0) {
            steps = (int)Math.min((long)steps, this.energyStorage.getEnergy() / (long)rf);
        }
        for (i = 0; i < steps; ++i) {
            if (this.craftOneCycle()) continue;
            this.noRecipesWork = true;
            break;
        }
        if ((rf *= i) > 0) {
            this.energyStorage.consumeEnergy((long)rf);
        }
    }

    private boolean craftOneCycle() {
        boolean craftedAtLeastOneThing = false;
        for (CraftingRecipe craftingRecipe : this.recipes) {
            if (!this.craftOneItem(craftingRecipe)) continue;
            craftedAtLeastOneThing = true;
        }
        return craftedAtLeastOneThing;
    }

    private boolean craftOneItem(CraftingRecipe craftingRecipe) {
        IRecipe recipe = craftingRecipe.getCachedRecipe(this.field_145850_b);
        if (recipe == null) {
            return false;
        }
        UndoableItemHandler undoHandler = new UndoableItemHandler((IItemHandlerModifiable)this.items);
        if (!this.testAndConsume(craftingRecipe, undoHandler)) {
            undoHandler.restore();
            return false;
        }
        ItemStack result = ItemStack.field_190927_a;
        try {
            result = recipe.func_77572_b((IInventory)this.workInventory);
        }
        catch (RuntimeException e) {
            Logging.logError((String)"Problem with recipe!", (Throwable)e);
        }
        CraftMode mode = craftingRecipe.getCraftMode();
        if (!result.func_190926_b() && this.placeResult(mode, (IItemHandlerModifiable)undoHandler, result)) {
            NonNullList remaining = recipe.func_179532_b((IInventory)this.workInventory);
            CraftMode remainingMode = mode == CraftMode.EXTC ? CraftMode.INT : mode;
            for (ItemStack s : remaining) {
                if (s.func_190926_b() || this.placeResult(remainingMode, (IItemHandlerModifiable)undoHandler, s)) continue;
                undoHandler.restore();
                return false;
            }
            return true;
        }
        undoHandler.restore();
        return false;
    }

    private boolean testAndConsume(CraftingRecipe craftingRecipe, UndoableItemHandler undoHandler) {
        int keep = craftingRecipe.getKeepOne() == KeepMode.KEEP ? 1 : 0;
        for (int i = 0; i < this.workInventory.func_70302_i_(); ++i) {
            this.workInventory.func_70299_a(i, ItemStack.field_190927_a);
        }
        IRecipe recipe = craftingRecipe.getCachedRecipe(this.field_145850_b);
        int w = 3;
        int h = 3;
        if (recipe instanceof ShapedRecipe) {
            w = ((ShapedRecipe)recipe).getRecipeWidth();
            h = ((ShapedRecipe)recipe).getRecipeHeight();
        }
        NonNullList ingredients = recipe.func_192400_c();
        for (int x = 0; x < w; ++x) {
            block2: for (int y = 0; y < h; ++y) {
                Ingredient ingredient;
                int index = y * w + x;
                if (index >= ingredients.size() || (ingredient = (Ingredient)ingredients.get(index)) == Ingredient.field_193370_a) continue;
                for (int j = 0; j < 26; ++j) {
                    int slotIdx = 10 + j;
                    ItemStack input = undoHandler.getStackInSlot(slotIdx);
                    if (input.func_190926_b() || input.func_190916_E() <= keep || !ingredient.test(input)) continue;
                    undoHandler.remember(slotIdx);
                    ItemStack copy = input.func_77979_a(1);
                    this.workInventory.func_70299_a(y * 3 + x, copy);
                    continue block2;
                }
            }
        }
        return recipe.func_77569_a((IInventory)this.workInventory, this.field_145850_b);
    }

    private boolean placeResult(CraftMode mode, IItemHandlerModifiable undoHandler, ItemStack result) {
        int stop;
        int start;
        if (mode == CraftMode.INT) {
            start = 10;
            stop = 36;
        } else {
            start = 36;
            stop = 40;
        }
        ItemStack remaining = InventoryTools.insertItemRanged((IItemHandler)undoHandler, (ItemStack)result, (int)start, (int)stop, (boolean)true);
        if (remaining.func_190926_b()) {
            InventoryTools.insertItemRanged((IItemHandler)undoHandler, (ItemStack)result, (int)start, (int)stop, (boolean)false);
            return true;
        }
        return false;
    }

    private void rememberItems() {
        for (int i = 0; i < this.ghostSlots.size(); ++i) {
            int slotIdx = i < 26 ? i + 10 : i + 36 - 26;
            if (this.items.getStackInSlot(slotIdx).func_190926_b()) continue;
            ItemStack stack = this.items.getStackInSlot(slotIdx).func_77946_l();
            stack.func_190920_e(1);
            this.ghostSlots.set(i, (Object)stack);
        }
        this.noRecipesWork = false;
        this.markDirtyClient();
    }

    private void forgetItems() {
        for (int i = 0; i < this.ghostSlots.size(); ++i) {
            this.ghostSlots.set(i, (Object)ItemStack.field_190927_a);
        }
        this.noRecipesWork = false;
        this.markDirtyClient();
    }

    public boolean isItemValidForSlot(int slot, @Nonnull ItemStack stack) {
        if (slot >= 0 && slot <= 9) {
            return false;
        }
        if (slot >= 10 && slot < 36) {
            ItemStack ghostSlot = (ItemStack)this.ghostSlots.get(slot - 10);
            if (!ghostSlot.func_190926_b() && !ghostSlot.func_77969_a(stack)) {
                return false;
            }
            ItemStack filterModule = this.items.getStackInSlot(40);
            if (!filterModule.func_190926_b() && this.filterCache.get() != null) {
                return ((Predicate)this.filterCache.get()).test(stack);
            }
        } else if (slot >= 36 && slot < 40) {
            ItemStack ghostSlot = (ItemStack)this.ghostSlots.get(slot - 36 + 26);
            if (!ghostSlot.func_190926_b() && !ghostSlot.func_77969_a(stack)) {
                return false;
            }
        } else if (slot == 40) {
            return stack.func_77973_b() instanceof FilterModuleItem;
        }
        return true;
    }
}

