/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.storage;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import mcjty.lib.worlddata.AbstractWorldData;
import mcjty.rftoolsstorage.storage.StorageEntry;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;

public class StorageHolder
extends AbstractWorldData<StorageHolder> {
    public static final String NAME = "RFToolsStorageHolder";
    private final Map<UUID, StorageEntry> storageEntryMap = new HashMap<UUID, StorageEntry>();

    private StorageHolder() {
        super(NAME);
    }

    public static StorageHolder get(World world) {
        return (StorageHolder)StorageHolder.getData((World)world, StorageHolder::new, (String)NAME);
    }

    public StorageEntry getOrCreateStorageEntry(UUID uuid, int size, String createdBy) {
        if (!this.storageEntryMap.containsKey(uuid)) {
            StorageEntry entry = new StorageEntry(size, uuid, createdBy);
            this.storageEntryMap.put(uuid, entry);
            this.save();
        } else {
            StorageEntry entry = this.storageEntryMap.get(uuid);
            if (size != entry.getStacks().size()) {
                entry.resize(size, createdBy);
            }
        }
        return this.storageEntryMap.get(uuid);
    }

    public StorageEntry getStorageEntry(UUID uuid) {
        return this.storageEntryMap.get(uuid);
    }

    public Collection<StorageEntry> getStorages() {
        return this.storageEntryMap.values();
    }

    public void func_76184_a(CompoundNBT nbt) {
        ListNBT storages = nbt.func_150295_c("Storages", 10);
        for (INBT storage : storages) {
            StorageEntry entry = new StorageEntry((CompoundNBT)storage);
            this.storageEntryMap.put(entry.getUuid(), entry);
        }
    }

    @Nonnull
    public CompoundNBT func_189551_b(@Nonnull CompoundNBT nbt) {
        ListNBT storages = new ListNBT();
        for (Map.Entry<UUID, StorageEntry> entry : this.storageEntryMap.entrySet()) {
            storages.add((Object)entry.getValue().write());
        }
        nbt.func_218657_a("Storages", (INBT)storages);
        return nbt;
    }
}

